%global optflags_lto %optflags_lto -ffat-lto-objects

%define oname lua
%global major_version 5.4
%global current_lua_version %major_version
%global test_version 5.4.6

Name: lua%major_version
Version: %major_version.6
Release: alt1

Summary: Powerful light-weight programming language
License: MIT
Group: Development/Other

Url: http://www.lua.org/
# repackaged tarball http://www.lua.org/ftp/lua-%version.tar.gz
Source0: lua-%version.tar
# repackaged tarball http://www.lua.org/tests/lua-%test_version-tests.tar.gz
Source1: lua-%test_version-tests.tar
Source2: lua.source0.watch
Source3: lua.source1.watch
# multilib
Source4: luaconf.h
# copied from readme.html
Source5: COPYRIGHT
Source44: import.info
Patch0: %oname-5.4.0-beta-autotoolize.patch
Patch1: %oname-5.3.0-idsize.patch
#Patch2:         %%{oname}-5.3.0-luac-shared-link-fix.patch
Patch3: %oname-5.2.2-configure-linux.patch
Patch4: %oname-5.3.0-configure-compat-module.patch
# lua bugs
Patch5: 25b143dd34fb587d1e35290c4b25bc08954800e2.patch
Patch6: 1f3c6f4534c6411313361697d98d1145a1f030fa.patch

BuildRequires: automake-common autoconf-common libtool-common readline-devel libncurses++-devel libncurses-devel libncursesw-devel libtic-devel libtinfo-devel
BuildRequires: rpm-build-lua
Requires: liblua = %version
Provides: lua = %EVR
Provides: lua5 = %EVR
Conflicts: lua5 <= 5.1.5-alt2
Conflicts: lua5.3 <= 5.3.6-alt1

%define common_descr \
Lua is a powerful light-weight programming language designed for\
extending applications. Lua is also frequently used as a\
general-purpose, stand-alone language. Lua is free software.\
Lua combines simple procedural syntax with powerful data description\
constructs based on associative arrays and extensible semantics. Lua\
is dynamically typed, interpreted from bytecodes, and has automatic\
memory management with garbage collection, making it ideal for\
configuration, scripting, and rapid prototyping.

%description
%common_descr

%package doc
Summary: Documentation for %oname
Group: Development/Documentation
BuildArch: noarch

%description doc
%common_descr

This package contains documantaion for %oname

%package -n lib%name-devel
Summary: Development files for %oname
Group: Development/C
Requires: %name = %version
Requires: rpm-build-lua
Provides: lua-devel = %EVR
Provides: lua%major_version-devel = %EVR
Provides: liblua-devel = %EVR
Provides: liblua5-devel = %EVR
Obsoletes: liblua5-devel < %EVR
Conflicts: liblua5-devel < %EVR
Conflicts: liblua4-devel < %version
Conflicts: liblua-devel < %version

%description -n lib%name-devel
%common_descr

This package contains development files for %oname.

%package -n lib%name
Group: Development/Other
Summary: Libraries for %oname
Provides: liblua = %EVR
Provides: liblua5 = %EVR
Provides: lua(abi) = %major_version

%description -n lib%name
%common_descr

This package contains the shared libraries for %oname.

%package -n lib%name-devel-static
Summary: Static library for %oname
Group: Development/C
Requires: %name%{?_isa} = %version-%release
Provides: lua-static = %EVR
Provides: lua-devel-static = %EVR
Provides: liblua5-devel-static = %EVR
Obsoletes: liblua5-devel-static < %EVR
Conflicts: liblua5-devel-static < %EVR
Conflicts: liblua4-devel-static < %version

%description -n lib%name-devel-static
%common_descr

This package contains the static version of liblua for %oname.

%prep
%setup -n %oname-%version -a 1
cp -a %SOURCE5 .
mv src/luaconf.h src/luaconf.h.template.in
%patch0 -p1 -E -z .autoxxx
%patch1 -p1 -z .idsize
#%% patch2 -p1 -z .luac-shared
%patch3 -p1 -z .configure-linux
%patch4 -p1 -z .configure-compat-all

%build
%autoreconf
%configure --with-readline --with-compat-module
sed -i 's|^hardcode_libdir_flag_spec=.*|hardcode_libdir_flag_spec=""|g' libtool
sed -i 's|^runpath_var=LD_RUN_PATH|runpath_var=DIE_RPATH_DIE|g' libtool
# Autotools give me a headache sometimes.
sed -i 's|@pkgdatadir@|%_datadir|g' src/luaconf.h.template

# hack so that only /usr/bin/lua gets linked with readline as it is the
# only one which needs this and otherwise we get License troubles
%make_build LIBS="-lm -ldl"
# only /usr/bin/lua links with readline now #luac_LDADD="liblua.la -lm -ldl"

%check
cd lua-%test_version-tests

# Removing tests that fail under mock/koji
sed -i.orig -e '
    /db.lua/d;
    /errors.lua/d;
    ' all.lua
LD_LIBRARY_PATH=%buildroot/%_libdir %buildroot/%_bindir/lua -e"_U=true" all.lua

%install
%makeinstall_std
rm %buildroot%_libdir/*.la
mkdir -p %buildroot%_libdir/lua/%major_version
mkdir -p %buildroot%_datadir/lua/%major_version

mv %buildroot%_bindir/lua{,-%major_version}
mv %buildroot%_bindir/luac{,-%major_version}
ln -s lua-%major_version %buildroot%_bindir/lua
ln -s luac-%major_version %buildroot%_bindir/luac
ln -s lua-%major_version %buildroot%_bindir/lua%major_version
ln -s luac-%major_version %buildroot%_bindir/luac%major_version
mv %buildroot%_man1dir/lua{,-%major_version}.1
mv %buildroot%_man1dir/luac{,-%major_version}.1
ln -s lua-%major_version.1 %buildroot%_man1dir/lua.1
ln -s lua-%major_version.1 %buildroot%_man1dir/luac.1
ln -s lua-%major_version.1 %buildroot%_man1dir/lua%major_version.1
ln -s lua-%major_version.1 %buildroot%_man1dir/luac%major_version.1

# pkgconfig
mv %buildroot%_pkgconfigdir/lua.pc %buildroot%_pkgconfigdir/lua-%current_lua_version.pc
ln -s lua-%current_lua_version.pc %buildroot%_pkgconfigdir/lua%current_lua_version.pc
ln -s lua-%current_lua_version.pc %buildroot%_pkgconfigdir/lua.pc

# Rename luaconf.h to luaconf-<arch>.h to avoid file conflicts on
# multilib systems and install luaconf.h wrapper
mv %buildroot%_includedir/luaconf.h %buildroot%_includedir/luaconf-%_arch.h
install -pm644 %SOURCE4 %buildroot%_includedir/luaconf.h

%ifarch %ix86
if ! [ -e %buildroot/%_includedir/luaconf-i386.h ]; then
  pushd %buildroot/%_includedir/
  ln -s luaconf-%_arch.h  luaconf-i386.h
  popd
fi
%endif

%ifarch %e2k
if ! [ -e %buildroot/%_includedir/luaconf-e2k.h ]; then
  pushd %buildroot/%_includedir/
  ln -s luaconf-%_arch.h  luaconf-e2k.h
  popd
fi
%endif

mkdir -p %buildroot%_sysconfdir/buildreqs/packages/substitute.d
echo lua-devel >%buildroot%_sysconfdir/buildreqs/packages/substitute.d/lib%name-devel
echo lua-devel-static >%buildroot%_sysconfdir/buildreqs/packages/substitute.d/lib%name-devel-static

%files
%_bindir/lua*
%_bindir/luac*
%_man1dir/lua*.1*

%files doc
%doc doc/*.html doc/*.css doc/*.gif doc/*.png

%files -n lib%name
%doc COPYRIGHT README
%_libdir/liblua-%major_version.so
%dir %_libdir/lua/%major_version
%dir %_datadir/lua/%major_version

%files -n lib%name-devel
%_includedir/l*.h
%_includedir/l*.hpp
%_libdir/liblua.so
%_pkgconfigdir/*.pc
%config %_sysconfdir/buildreqs/packages/substitute.d/lib%name-devel

%files -n lib%name-devel-static
%_libdir/*.a
%config %_sysconfdir/buildreqs/packages/substitute.d/lib%name-devel-static

%changelog
