# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

Name: lxqt-config
Version: 2.2.0
Release: alt1

Summary: LXDE-Qt system configurations (control center)
License: LGPL-2.1-or-later
Group: Graphical desktop/Other

Url: https://lxqt.org
Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires: gcc-c++ cmake rpm-macros-cmake
BuildRequires: libXau-devel libXcursor-devel libXdmcp-devel libXfixes-devel
BuildRequires: liblxqt-devel >= 2.0.0
BuildRequires: libqt6xdg-devel qt6-base-devel qt6-tools-devel
BuildRequires: plasma6-libkscreen-devel
BuildRequires: kf6-kwindowsystem-devel
BuildRequires: qt6-svg-devel
BuildRequires: rpm-build-xdg
BuildRequires: zlib-devel
BuildRequires: pkgconfig(xorg-libinput)
BuildRequires: libudev-devel
BuildRequires: lxqt-menu-data-devel >= 2.0.0
BuildRequires: libXi-devel

Requires: lxqt-menu-data >= 2.0.0
Requires: plasma6-libkscreen-utils

Provides: razorqt-config = %version
Obsoletes: razorqt-config < 0.7.0

Provides: lxqt-config-randr = %version
Obsoletes: lxqt-config-randr < 0.8.0

%description
%summary

%prep
%setup
%autopatch -p1

%build
%cmake  -DCMAKE_SKIP_RPATH:BOOL=OFF \
	-DCMAKE_SKIP_INSTALL_RPATH:BOOL=OFF
%cmake_build

%install
%cmake_install

%files
%_bindir/*
%_libdir/%name/*.so
%_datadir/lxqt/*
%_man1dir/*
%_desktopdir/*.desktop
%_iconsdir/*/*/*/*
%doc AUTHORS CHANGELOG LICENSE README.md

%changelog
