# SPDX-License-Identifier: GPL-2.0-only
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

Name:    makedumpfile
Version: 1.7.7
Release: alt1
Summary: Make Linux crash dump small by filtering and compressing pages
Group:   System/Kernel and hardware
License: GPL-2.0-only
Url:     https://github.com/makedumpfile/makedumpfile
# Wiki:  https://github.com/makedumpfile/makedumpfile/wiki

Source: %name-%version.tar

BuildRequires: bzlib-devel
BuildRequires: libdw-devel
BuildRequires: libelf-devel
BuildRequires: libeppic-devel >= 4.0.0.13.gdc60e00-alt3
BuildRequires: liblzma-devel
BuildRequires: liblzo2-devel
BuildRequires: libncurses-devel
BuildRequires: libsnappy-devel
BuildRequires: libzstd-devel
BuildRequires: perl-Math-BigInt
BuildRequires: zlib-devel

%description
The makedumpfile can make a Linux crash dump smaller.
- Exclude unnecessary pages for crash analysis
- Compress dump data with zlib, lzo or snappy
- Multi-thread processing

%prep
%setup
sed -i 's/-leppic/& -ldl/' Makefile

%build
export CFLAGS="%optflags"
export USELZO=on
export USEZSTD=on
export USESNAPPY=on
export LINKTYPE=dynamic
%make_build
%make_build eppic_makedumpfile.so

%install
%makeinstall_std
install -Dm0755 eppic_makedumpfile.so %buildroot%_libdir/%name/eppic_makedumpfile.so

%files
%doc COPYING README IMPLEMENTATION
%_sbindir/makedumpfile
%_sbindir/makedumpfile-R.pl
%_man5dir/makedumpfile.conf.5.xz
%_man8dir/makedumpfile.8.xz
%_datadir/makedumpfile
%_libdir/%name

%changelog
