Name: mcelog
Version: 196
Release: alt1

Summary: Tool to translate x86_64 CPU Machine Check Exception data
License: GPLv2
Group: System/Kernel and hardware

Url: https://github.com/andikleen/mcelog.git
Source0: %name-%version.tar
Source1: mcelog.conf
Source2: mcelog.init
Source3: mcelog.service
Source4: mcelog.cron
Source5: mcelog.logrotate

ExclusiveArch: x86_64 %ix86

%define trigdir %_sysconfdir/mcelog/triggers

%package cron
Summary: Optional cronjob for mcelog
Group: System/Kernel and hardware

%description
mcelog is a utility that collects and decodes Machine Check Exception
data on x86-32 and x86-64 systems. It should be run as a service.

%description cron
This package contains the cronjob and logrotate configuration
for mcelog; note though that it's much preferred to run it as
a service.

%prep
%setup

%build
mkdir -p %buildroot{%_sysconfdir,%_sbindir,%_mandir}
make CFLAGS="%optflags -fpie -pie"

%post
%post_service mcelog

%install
install -pDm755 mcelog %buildroot%_sbindir/mcelog
install -pDm644 %SOURCE1 %buildroot%_sysconfdir/mcelog/mcelog.conf
install -pDm755 triggers/cache-error-trigger %buildroot%trigdir/cache-error-trigger
install -pDm755 triggers/dimm-error-trigger %buildroot%trigdir/dimm-error-trigger
install -pDm755 triggers/page-error-trigger %buildroot%trigdir/page-error-trigger
install -pDm755 triggers/socket-memory-error-trigger %buildroot%trigdir/socket-memory-error-trigger
install -pDm755 %SOURCE2 %buildroot%_initdir/mcelog
install -pDm644 %SOURCE3 %buildroot%_unitdir/mcelog.service
install -pDm755 %SOURCE4 %buildroot%_sysconfdir/cron.hourly/mcelog.cron
install -pDm600 %SOURCE5 %buildroot%_sysconfdir/logrotate.d/mcelog
install -pDm644 mcelog.8 %buildroot%_man8dir/mcelog.8

%files
%doc README.md
%_sbindir/mcelog
%dir %_sysconfdir/mcelog
%_sysconfdir/logrotate.d/mcelog
%config(noreplace) %_sysconfdir/mcelog/mcelog.conf
%trigdir
%_initdir/mcelog
%_unitdir/mcelog.service
%_man8dir/*

%files cron
%_sysconfdir/cron.hourly/mcelog.cron

%changelog
