%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

%def_disable cluster
%define nowarn -Wno-implicit-fallthrough -Wno-format-truncation -Wno-format-overflow

Name: mdadm
Version: 4.4
Release: alt3

Summary: A tool for managing Soft RAID under Linux
License: GPLv2+
Group: System/Configuration/Hardware
Url: https://raid.wiki.kernel.org/index.php/Linux_Raid

Vcs: https://git.kernel.org/pub/scm/utils/mdadm/mdadm.git
Source: %name-%version.tar
Patch: %name-%version.patch

BuildRequires: binutils-devel libudev-devel
%{?_enable_cluster:BuildRequires: libcorosync-devel libdlm-devel}

# due to /lib/udev/rules.d/64-md-raid.rules
Conflicts: udev < 151

# Pull in the tool subpackage on a package update, but
# allow it to be installed individually
Requires: %name-tool = %EVR

%description
mdadm is a program that can be used to create, manage, and monitor
Linux MD (Software RAID) devices.

As such is provides similar functionality to the raidtools packages.
The particular differences to raidtools is that mdadm is a single
program, and it can perform (almost) all functions without a
configuration file (that a config file can be used to help with
some common tasks).

%package tool
Summary: Primary '%name' command line tool for MD arrays maintenance
Group: System/Configuration/Hardware
%description tool
%summary

%package doc
Summary: Optional documentation for %name
Group: Documentation
BuildArch: noarch
%description doc
%summary

%prep
%setup
%patch -p1

%build
%add_optflags -D_FILE_OFFSET_BITS=64

%make_build mdadm mdmon raid6check CXFLAGS='%optflags %nowarn' SYSCONFDIR='%_sysconfdir'

%install
%makeinstall_std install-systemd MANDIR=%_mandir BINDIR=%_sbindir SYSTEMD_DIR=%_unitdir UDEVDIR=%_udevdir
install -pD -m755 alt/mdadm.init %buildroot%_initdir/mdadm
install -pD -m755 misc/syslog-events %buildroot%_sbindir/mdadm-syslog-events
install -pD -m600 alt/mdadm.conf %buildroot%_sysconfdir/mdadm.conf.sample
touch %buildroot%_sysconfdir/mdadm.conf
# install -pD -m644 alt/mdadm.service %%buildroot%%_unitdir/mdadm.service
ln -r -s %buildroot%_unitdir/mdmonitor.service %buildroot%_unitdir/mdadm.service

install -pD -m755 alt/checkarray %buildroot%_datadir/mdadm/checkarray
install -pD -m644 alt/mdadm.sysconfig %buildroot%_sysconfdir/sysconfig/mdadm
install -pD -m644 alt/mdadm.crond %buildroot%_sysconfdir/cron.d/mdadm

# raid6check
install -pD -m755 raid6check %buildroot/%_sbindir/raid6check
install -pD -m644 raid6check.8 %buildroot/%_man8dir/raid6check.8

# Cleanup (need adapt for mdadm_env.sh)
rm -f %buildroot%_unitdir/{mdmonitor-oneshot,mdcheck_continue,mdcheck_start}.{service,timer}

%post -f alt/raidtabtomdadm.sh
%post_service mdadm

%preun
%preun_service mdadm

%files
%_sbindir/mdadm-syslog-events
%_sbindir/mdmon
%_man8dir/mdmon.*
%_sbindir/raid6check
%_man8dir/raid6check.*
%config %_sysconfdir/mdadm.conf.sample
%config(noreplace) %_sysconfdir/sysconfig/mdadm
%_sysconfdir/cron.d/mdadm
%_initdir/mdadm
%_datadir/mdadm/
%_udevrulesdir/01-md-raid-creating.rules
%_udevrulesdir/63-md-raid-arrays.rules
%_udevrulesdir/64-md-raid-assembly.rules
%_udevrulesdir/69-md-clustered-confirm-device.rules
%_unitdir/*
%_systemddir/system-shutdown/mdadm.shutdown

%files tool
%_sbindir/mdadm
%_man8dir/mdadm.*
%_man4dir/md.*
%_man5dir/mdadm.conf.*
%ghost %config(noreplace,missingok) %_sysconfdir/mdadm.conf

%files doc
%doc README.md MAINTAINERS.md CHANGELOG.md documentation
%doc alt/README*

%changelog
