%def_disable snapshot

%define ver_major 3.22
%define xdg_name org.gnome.Meld

%def_enable check

Name: meld
Version: %ver_major.3
Release: alt1

Summary: Meld Diff Viewer
License: GPL-2.0-or-later
Group: Text tools
Url: https://meld.app

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

BuildArch: noarch

%define gtk_api_ver 3.0
%define gtksource_api_ver 4

Requires: dconf
Requires: typelib(Gtk) = %gtk_api_ver
Requires: typelib(GtkSource) = %gtksource_api_ver
Requires: librsvg icon-theme-adwaita

BuildRequires(pre): rpm-macros-meson rpm-build-gir rpm-build-python3
BuildRequires: meson yelp-tools /usr/bin/appstream-util desktop-file-utils
BuildRequires: python3-devel python3-module-pygobject3-devel python3-module-pycairo-devel
BuildRequires: gir(Gtk) = %gtk_api_ver gir(GtkSource) = %gtksource_api_ver

%description
Meld is a visual diff and merge tool. It lets you compare two or three
files, and updates the comparisons while you edit them in-place. You
can also compare folders, launching comparisons of individual files as
desired. Last but by no means least, Meld lets you work with your
current changes in a wide variety of version control systems,
including Git, Bazaar, Mercurial, Subversion and CVS.

%prep
%setup

%build
%meson -Dbyte-compile=false
%meson_build

%install
%meson_install
%find_lang %name --with-gnome

%check
%__meson_test

%files -f %name.lang
%attr(0755,root,root) %_bindir/%name
%python3_sitelibdir_noarch/*
%exclude %python3_sitelibdir_noarch/%name/build_helpers.py
%_datadir/%name/
%_desktopdir/%xdg_name.desktop
%_iconsdir/hicolor/*/*/*
%_datadir/glib-2.0/schemas/org.gnome.meld.gschema.xml
%_datadir/mime/packages/%xdg_name.xml
%_datadir/metainfo/%xdg_name.appdata.xml
%_man1dir/%name.1.*
%doc NEWS README*

%changelog
