Name: memtest86+
Version: 7.20
Release: alt1

Summary: Memory test for x86 architecture
License: GPL-2.0-or-later
Group: System/Kernel and hardware

Url: http://www.memtest.org
Source: %name-%version.tar
Patch: %name-%version-%release.patch

ExclusiveArch: %ix86 x86_64 loongarch64
Requires(post,preun): bootloader-utils >= 0.3

%ifarch %ix86
%define builddir build32
%endif
%ifarch x86_64
%define builddir build64
%endif
%ifarch loongarch64
%define builddir build64/la64
%endif

%description
Memtest86 is thorough, standalone memory test for x86 systems. It is
a standalone program and can be loaded from either a disk partition via
lilo or a floppy disk. Memtest86 uses a "moving inversions" algorithm
that is proven to be effective in finding memory errors.  The BIOS based
memory test is just a quick check that will often miss many of the
failures that are detected by Memtest86.

The ELF version should be used for booting from grub,
and avoids the following errors:
"Error 7: Loading below 1MB is not supported"
"Error 13: Invalid or unsupported executable format"
"Error 28: Selected item cannot fit into memory"

%description -l ru_RU.UTF-8
Тщательный и самостоятельный тест памяти для x86-систем, который может
быть загружен или с жесткого диска при помощи LILO/GRUB, или с дискеты.

Тест использует алгоритм "движущихся инверсий", доказавший свою
эффективность при обнаружении сбоев памяти. Не обращайте внимания на
"тест" BIOS: он практически ничего не значит, так как пропустит много
ошибок из тех, которые обнаружит memtest86.

Также может использоваться для создания загрузочной тест-дискеты.

%description -l uk_UA.UTF-8
Ретельний та самостійний тест пам'яті для x86-систем, що може бути
завантажений як з жорсткого диску за допомогою LILO/GRUB, так і з
дискети.

Тест використовує алгоритм "рухаючихся інверсій", який довів свою
ефективність при визначенні негараздів із пам'яттю. Не звертайте уваги
на "тест" BIOS: він практично нічого не означає, тому що пройде повз
багатьох збоїв з тих, що знаходить memtest86.

Також може використовуватися для створення завантажувальної
тест-дискети.

%prep
%setup
%patch -p1

%build
cd %builddir
%make_build LD=/usr/bin/ld.bfd

%install
cd %builddir
%ifarch %ix86 x86_64
install -pDm644 memtest.bin %buildroot/boot/memtest-%version.bin
%endif
%ifnarch %ix86
install -pDm644 memtest.efi %buildroot/boot/memtest-%version.efi
%endif
mkdir -p %buildroot%_sbindir
ln -s `relative /sbin/installkernel %_sbindir/installmemtest86+` \
	%buildroot%_sbindir/installmemtest86+

%post
%_sbindir/installmemtest86+ %version

%preun
%_sbindir/installmemtest86+ --remove %version

%files
%ifarch %ix86 x86_64
/boot/memtest-%version.bin
%endif
%ifnarch %ix86
/boot/memtest-%version.efi
%endif
%_sbindir/installmemtest86+
%doc README.md

%changelog
