%global import_path github.com/minio/minio
%global commit 9e49d5e7a648f00e26f2246f4dc28e6b07f8c84a
%global shortcommit %(c=%{commit}; echo ${c:0:12})
%global tag RELEASE.2025-10-15T17-29-55Z
%define version 2025.10.15

%global _unpackaged_files_terminate_build 1

Name: minio
Version: %version
Release: alt3
Summary: Cloud Storage Server
Group: System/Servers
License: AGPL-3.0
Url: https://www.min.io/

Source: %name-%version.tar
Source3: %name.sysconfig
Source4: %name.service

Patch: %name-%version.patch

ExclusiveArch: %go_arches
BuildRequires(pre): rpm-macros-golang
BuildRequires: rpm-build-golang golang >= 1.24.8

%description
MinIO is an object storage server released under Apache License v2.0.
It is compatible with Amazon S3 cloud storage service. It is best
suited for storing unstructured data such as photos, videos, log
files, backups and container / VM images. Size of an object can
range from a few KBs to a maximum of 5TiB.

%prep
%setup -q
%patch -p1


%build
export BUILDDIR="$PWD/.gopath"
export IMPORT_PATH="%import_path"
export GOPATH="$BUILDDIR:%go_path"
export GOFLAGS="-mod=vendor"
export TAG=%tag
export VERSION=${TAG#RELEASE.}
export COMMIT=%commit
export SCOMMIT=%shortcommit
export YEAR=2025
export prefix=%import_path/cmd

# setup flags like 'go run buildscripts/gen-ldflags.go' would do
export LDFLAGS="-X $prefix.Version=$VERSION -X $prefix.ReleaseTag=$TAG -X $prefix.CommitID=$COMMIT -X $prefix.ShortCommitID=$SCOMMIT  -X .$prefix.CopyrightYear=$YEAR"
export TAGS="kqueue"

sed -e "s|DEVELOPMENT.GOGET|$VERSION|g" -i cmd/build-constants.go

%golang_prepare
pushd $BUILDDIR/src/%import_path
%gobuild -tags kqueue -trimpath -o %name .
#CGO_ENABLED=0 %golang_build .
popd

%install
export BUILDDIR="$PWD/.gopath"
mkdir -p -- \
        %buildroot%_bindir \
        %buildroot%_unitdir \
        %buildroot%_sysconfdir/%name/certs \
        %buildroot%_sharedstatedir/%name \
        %buildroot%_logdir/%name

cd .gopath/src/%import_path
install -p -m 755 %name %buildroot%_bindir/%name
install -D -p -m 0644 %SOURCE3 %buildroot%_sysconfdir/sysconfig/%name
install -D -p -m 0644 %SOURCE4 %buildroot%_unitdir/%name.service

%pre
groupadd -r -f _%name
useradd -r -g _%name -c "Minio" -d %_sharedstatedir/%name -s /dev/null -n _%name >/dev/null 2>&1 ||:

%post
%post_service %name

%preun
%preun_service %name

%files
%doc README.md
%_bindir/minio
%dir %attr(750,root,_%name) %_sysconfdir/%name
%dir %attr(750,root,_%name) %_sysconfdir/%name/certs
%config(noreplace) %attr(640,root,_%name) %_sysconfdir/sysconfig/%name
%dir %attr(750,_%name,_%name) %_sharedstatedir/%name
%dir %attr(750,_%name,_%name) %_logdir/%name
%_unitdir/%name.service

%changelog
