%def_with nas
%def_with pulse
%def_with sdl
# disabled by default
%def_disable portable
# "to not attempt to use 64 bit file offsets internally"
# enabled by default
%def_enable largefile

# list of audio output modules
%define mods alsa oss %{?_with_nas:nas} %{?_with_pulse:pulse} %{?_with_sdl:sdl}

%def_enable check

Name: mpg123
Version: 1.32.10
Release: alt1
Epoch: 1

Summary: MPEG audio player
Group: Sound
License: GPL-2.0 and LGPL-2.1
Url: http://www.%name.org

#Vcs: svn://scm.orgis.org/mpg123/trunk
Vcs: https://github.com/madebr/mpg123.git

Source: http://downloads.sourceforge.net/%name/%name-%version.tar.bz2
Source1: mp3license

Requires: libmpg123 = %EVR

%ifarch %ix86
%define wcpu i586
%else
%ifarch x86_64
%define wcpu x86-64
%else
%define wcpu generic
%endif
%endif

BuildRequires: libalsa-devel
%{?_with_nas:BuildRequires: libaudio-devel}
%{?_with_sdl:BuildRequires: libSDL2-devel libsdl2_sound-devel}
%{?_with_pulse:BuildRequires: libpulseaudio-devel}

%description
Mpg123 is a fast, free and portable MPEG audio player for Unix.
It supports MPEG 1.0/2.0 layers 1, 2 and 3 ("mp3" files).  For
full CD quality playback (44 kHz, 16 bit, stereo) a fast CPU
is required. Mono and/or reduced quality playback (22 kHz or
11 kHz) is possible on slow CPUs (like Intel 486).

For information on the MP3 License, please visit:
%url

%package -n libmpg123
Summary: mpg123 library
Group: System/Libraries
License: LGPL-2.1

%description -n libmpg123
This package provides mpg123 library.

%package -n libmpg123-devel
Summary: mpg123 library headers
Group:  Development/C
License: LGPL-2.1
Requires: libmpg123 = %EVR

%description -n libmpg123-devel
This package provides mpg123 library headers


%prep
%setup
install -p -m644 %SOURCE1 .

%build
%autoreconf
# since 1.32.6 this is a cause of ABI break for 32-bit
#%%add_optflags %optflags_shared %(getconf LFS_CFLAGS)
%configure \
	%{subst_enable portable} \
	%{subst_enable largefile} \
	--with-audio="%mods" \
	--with-optimization=0 \
	--enable-network=yes \
	--enable-ipv6 \
	--with-cpu=%{wcpu}
%nil
%make_build CFLAGS="%optflags -Wformat -Werror=format-security"

%install
%makeinstall_std
mkdir -p %buildroot%_defaultdocdir/%name-%version/
%find_lang %name

%check
%make -k check VERBOSE=1

%files -f %name.lang
%_bindir/%name
%_bindir/%name-id3dump
%_bindir/%name-strip
%_bindir/out123
%_man1dir/%name.1.*
%_man1dir/out123.1.*
%dir %_libdir/%name
%_libdir/%name/*.so
%doc AUTHORS ChangeLog COPYING INSTALL NEWS README mp3license doc/

%files -n libmpg123
%_libdir/libmpg123.so.*
%_libdir/libout123.so.*
%_libdir/libsyn123.so.*
%doc NEWS.lib%name

%files -n libmpg123-devel
%_libdir/libmpg123.so
%_libdir/libout123.so
%_libdir/libsyn123.so
%_pkgconfigdir/lib%name.pc
%_pkgconfigdir/libout123.pc
%_pkgconfigdir/libsyn123.pc
%_includedir/*.h


%changelog
