Name: mtr
Version: 0.95
Release: alt2

Summary: Matt's Traceroute - network diagnostic tool
License: GPLv2
Group: Monitoring

Url: http://www.bitwizard.nl/mtr/

Source: http://ftp.bitwizard.nl/mtr/mtr-%version.tar.gz
Source2: mtr.ru.UTF-8.8
Source3: mtr-packet.ru.UTF-8.8
Source4: mtr.desktop
Source5: mtr.xpm
Source6: mtr.control

Requires: mtr-packet = %EVR
Requires(pre): shadow-utils
Requires: /var/resolv

BuildRequires: libgtk+3-devel libncurses-devel
BuildRequires: pkgconfig(jansson)

Summary(ru_RU.UTF-8): Matt's Traceroute - утилита для диагностики сети
Summary(uk_UA.UTF-8): Matt's Traceroute - утиліта для діагностики мережі

%package -n xmtr
Summary: Ping/Traceroute network diagnostic tool - GTK Interface
Summary(ru_RU.UTF-8): Ping/Traceroute - утилита для диагностики сети - GTK интерфейс
Summary(uk_UA.UTF-8): Ping/Traceroute - утиліта для діагностики мережі - GTK інтерфейс
Group: Monitoring
Provides: %name-gtk = %version-%release
Obsoletes: %name-gtk
Requires: mtr-packet = %EVR
Requires: %name = %version-%release

%package -n mtr-packet
Summary: Ping/Traceroute network diagnostic tool - packet sender
Summary(ru_RU.UTF-8): Ping/Traceroute - утилита для диагностики сети - отправитель пакетов
Group: Monitoring
# Starting with mtr 0.95-alt1, the `mtr' control facility has been moved
# from the `mtr' package to this package.
Conflicts: mtr < 0.95

%description
mtr combines the functionality of the traceroute and ping programs in
a single network diagnostic tool.  As mtr starts, it investigates the
network connection between the host mtr runs on and the destination.
After it determines the address of each network hop between the machines,
it sends a sequence ICMP ECHO requests to each one to determine the
quality of the link to each machine.  As it does this, it prints running
statistics about each machine.

%description -l ru_RU.UTF-8
mtr - это traceroute и ping в одном флаконе.  При старте программа
исследует сетевое соединение между машиной, на которой она запущена,
и машиной, заданной пользователем.  После того, как она определит
адреса каждого хопа между этими двумя машинами, программа посылает
последовательность ICMP ECHO запросов на каждый из хопов для определения
качества связи с каждой из машин.  По мере того, как она это делает,
выводится текущая статистика по каждой машине.

%description -l uk_UA.UTF-8
mtr - це traceroute та ping в одному флаконі.  При запуску mtr
досліджує мережеве з'єднання між машиною, на якій він запущений та
заданою користувачем.  Після визначення адрес кожного хопу між цими
двома машинами, mtr посилає послідовність ICMP ECHO запитів на кожний
з хопів для визначення якості лінка до кожної з машин.  В ході цього
процесу mtr виводить поточну статистику по кожній машині.

%description -n xmtr
mtr is a network diagnostic tool which combines Ping and Traceroute
into one program.

This is the GTK interface for mtr.

%description -l ru_RU.UTF-8 -n xmtr
mtr - утилита для диагностики сети, сочетающая ping и traceroute
в одном "флаконе".

Этот пакет содержит GTK-интерфейс к mtr.

%description -l uk_UA.UTF-8 -n xmtr
mtr - утиліта для діагностики мережі, що поєднує ping та traceroute
в одному "флаконі".

Це GTK-інтерфейс до mtr.

%description -n mtr-packet
mtr is a network diagnostic tool which combines Ping and Traceroute
into one program.

This package contains the somewhat-privileged packet sender for mtr.

%prep
%setup
touch ChangeLog

%build
# setcap(8) does not work as builder, and the upstream
# make rule resorts to enabling set-uid in this case.
# Let's prevent that.
subst 's/|| chmod u+s/|| :/' Makefile.am
# It is not obvious how to pass the version of mtr to the build system. Let's
# patch Makefile.in directly.
subst 's/@PACKAGE_VERSION@/%version/' Makefile.in

%define _configure_script ../configure

mkdir -p build-xmtr
pushd build-xmtr
	%configure --sbindir=%_bindir --with-jansson --with-gtk --enable-ipv6
	%make_build
popd

mkdir -p build-mtr
pushd build-mtr
	%configure --sbindir=%_bindir --with-jansson --without-gtk --enable-ipv6
	%make_build
popd

%install
%makeinstall_std -C build-mtr

install -pD -m755 build-mtr/mtr %buildroot%_bindir/mtr
install -pD -m755 build-xmtr/mtr %buildroot%_bindir/xmtr
ln -s mtr %buildroot%_bindir/mtr6
ln -s xmtr %buildroot%_bindir/mtr-gtk

# The rights on this directory are to be manipulated by a control(8) facility.
mkdir -p %buildroot%_libexecdir/mtr
mv %buildroot%_bindir/mtr-packet %buildroot%_libexecdir/mtr/
ln -sr %buildroot%_libexecdir/mtr/mtr-packet %buildroot%_bindir/mtr-packet

install -pD -m644 %_sourcedir/mtr.desktop %buildroot%_desktopdir/mtr.desktop
install -pD -m644 %_sourcedir/mtr.xpm %buildroot%_niconsdir/mtr.xpm
install -pD -m755 %_sourcedir/mtr.control "%buildroot%_controldir/mtr"
subst -p "s)@NAME@)mtr-packet); s)@LIBEXECDIR@)%_libexecdir)" "%buildroot%_controldir/mtr"

%pre -n mtr-packet
/usr/sbin/groupadd -r -f netadmin
%pre_control mtr
if [ ! -r /var/run/control/mtr-packet.preserved ]; then
# We're looking at pre-installed, pre-expanded content; hence absolute paths
# and values.
case "$(grep '^BINARY=' /etc/control.d/facilities/mtr)" in
*="'"/usr/bin/mtr"'")
# Compatibility measure: preserve admin setting from mtr < 0.95.
mkdir -p /var/run/control
%_sbindir/control mtr > /var/run/control/mtr-packet.preserved
;;
esac
fi

%post -n mtr-packet
%post_control -s netadmin mtr
if [ -r /var/run/control/mtr-packet.preserved ]; then
# Compatibility measure: reapply preserved setting from mtr < 0.95.
%_sbindir/control mtr $(cat /var/run/control/mtr-packet.preserved)
rm -f /var/run/control/mtr-packet.preserved
fi

%files
%_bindir/mtr
%_bindir/mtr6
%_man8dir/mtr.8*
%_datadir/bash-completion/completions/mtr
%doc AUTHORS NEWS SECURITY TODO

%files -n xmtr
%_bindir/xmtr
%_bindir/mtr-gtk
%_desktopdir/*.desktop
%_niconsdir/*.xpm
%doc AUTHORS NEWS SECURITY TODO

%files -n mtr-packet
%_libexecdir/mtr
%_bindir/mtr-packet
%_man8dir/mtr-packet.8*
%config %_controldir/mtr

# TODO:
# - update russian manpage and get it back into the package?
# FIXME:
# - netadmin group would get non-predictable gid if not pre-existed

%changelog
