%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict,lint=relaxed

Name: musl
Version: 1.2.5
Release: alt6
Group: System/Libraries
Summary: Implementation of the C standard library
License: MIT
Url: https://musl.libc.org/
Vcs: https://git.musl-libc.org/cgit/musl/

Source: %name-%version.tar

%description
%summary.

%package libc
Summary: Shared library and dynamic linker for musl
Group: System/Libraries

%description libc
%summary.

%package devel
Summary: Development files for musl
Group: Development/C
Provides: musl-gcc = %EVR
AutoReq: nocpp
Requires: musl-libc = %EVR
Requires: kernel-headers-common

%description devel
musl is an implementation of the C standard library built on top of
the Linux system call API, including interfaces defined in the base
language standard, POSIX, and widely agreed-upon extensions. musl is
lightweight, fast, simple, free, and strives to be correct in the sense
of standards-conformance and safety.

Note that only GCC is supported; Clang support is best effort.

%package devel-static
Summary: Static libraries for musl
Group: Development/C
Requires: musl-devel = %EVR

%description devel-static
%summary.

%package -n rpm-macros-musl
Summary: RPM macros to find musl libraries
Group: Development/Other

%description -n rpm-macros-musl
%summary. This should be rarely needed,
and is not required for normal builds.

%package checkinstall
Summary: CI tests for musl
Group: Development/Other
BuildArch: noarch
Requires(post): musl-devel-static = %EVR
Requires(post): clang
Requires(post): gcc
Requires(post): toilet

%description checkinstall
%summary.

%prep
%setup
%ifnarch %ix86
sed -i '/link_ssp:/{N;N;d}' tools/musl-gcc.specs.sh
%endif

# Use musl-fts from Debian.
mkdir -p src/fts
cp debian/musl-fts/fts.c debian/musl-fts/config.h src/fts/
cp debian/musl-fts/fts.h include/

%define _muslarch %_arch
%ifarch armh
%define _muslarch armhf
%endif
%ifarch ppc64le
%define _muslarch powerpc64le
%endif
%ifarch %ix86
%define _muslarch i386
%endif
%define ldname ld-musl-%_muslarch.so.1
%define ldpath ld-musl-%_muslarch.path
%define soname libc.so
%define _musldir %_prefix/%_lib/musl

%build
%define optflags_lto %nil
%global _libdir %_musldir/lib
%global _includedir %_musldir/include
%ifarch ppc64le
# [ppc64le] checking whether compiler's long double definition matches float.h... no
# [ppc64le] ./configure: error: unsupported long double type
# We set this via CC (and not CFLAGS) so it also pass into musl-gcc by default.
export CC='gcc -mlong-double-64'
%endif
# Hide boring warnings, upstream seems don't care so we should not.
%add_optflags -Wno-parentheses -Wno-unused-but-set-variable -Wno-unused-value -Wno-unknown-pragmas
%configure \
	--prefix=%_musldir \
	--enable-debug \
	--enable-wrapper=all
%make_build
%ifarch %ix86
gcc %optflags -c .gear/__stack_chk_fail_local.c
ar rc libssp_nonshared.a __stack_chk_fail_local.o
%endif

%install
%make_install DESTDIR=%buildroot install
%ifarch %ix86
install -Dpm644 libssp_nonshared.a -t %buildroot%_libdir
%endif

# https://wiki.musl-libc.org/guidelines-for-distributions
#   "Most importantly [...] distributions should not change the dynamic
#   linker location to /lib64 or anything else, since this breaks ABI."
mkdir -p %buildroot/lib
mv %buildroot%_libdir/%soname %buildroot/lib/%ldname
ln -rs %buildroot/lib/%ldname %buildroot%_libdir/%soname
mkdir %buildroot%_sysconfdir
cat <<-EOF > %buildroot%_sysconfdir/%ldpath
	%_libdir
EOF

# UAPI headers.
rpm -ql kernel-headers-common | grep ^/usr/include/ |
	xargs -t ln -s -t %buildroot%_includedir

mkdir -p %buildroot%_rpmmacrosdir
cat > %buildroot%_rpmmacrosdir/musl <<-EOF
	%%_musl_libdir %_libdir
	%%_musl_includedir %_includedir
EOF

# Cannot be in %%pre.
install -Dp .gear/checkinstall %buildroot%_datadir/%name-checkinstall/_post

%check
grep 'ldso=' %buildroot%_bindir/ld.musl-clang
grep -Ex 'ldso="/lib/%ldname"' %buildroot%_bindir/ld.musl-clang

%post checkinstall -p %_datadir/%name-checkinstall/_post

%files libc
%doc COPYRIGHT
%_sysconfdir/%ldpath
/lib/%ldname
%dir %_musldir
%dir %_libdir
%_libdir/%soname

%files devel
%doc README WHATSNEW
%_bindir/*
%_includedir
%_libdir/*.o
%_libdir/musl-gcc.specs
%ifarch %ix86
%_libdir/libssp_nonshared.a
%endif

%files devel-static
%_libdir/libc.a
%_libdir/libcrypt.a
%_libdir/libdl.a
%_libdir/libm.a
%_libdir/libpthread.a
%_libdir/libresolv.a
%_libdir/librt.a
%_libdir/libutil.a
%_libdir/libxnet.a

%files -n rpm-macros-musl
%_rpmmacrosdir/musl

%files checkinstall
%_datadir/%name-checkinstall

%changelog
