%define gdal_version 37

Name: mysql-workbench-community
Version: 8.0.43
Release: alt1

Summary: A MySQL visual database modeling tool

License: GPLv2+ and LGPLv2+
Group: Development/Databases
Url: http://wb.mysql.com

# Source-url: https://cdn.mysql.com/Downloads/MySQLGUITools/mysql-workbench-community-%version-src.tar.gz
Source0: %name-%version.tar
# TODO: build with external antlr4-runtime (>= 4.7.1)
Source1: antlr-4.13.2-complete.jar

# https://www.mysql.com/support/supportedplatforms/workbench.html
ExclusiveArch: x86_64 aarch64 loongarch64 riscv64

Patch0: mysql-workbench-community-8.0.32-alt-suppress-unsupported.patch
Patch1: %name-8.0.20-alt-boost-1.73.0-compat.patch
Patch2: %name-8.0.33-alt-fix-finding-odbc.patch
Patch3: %name-8.0.33-alt-arm-fix.patch
Patch4: %name-8.0.40-alt-fix-gcc14-build.patch
Patch5: %name-8.0.43-swig-4.3.patch

Provides: mysql-workbench-oss = %version-%release
Obsoletes: mysql-workbench-oss < %version-%release
Provides: mysql-workbench-gpl = %version-%release
Obsoletes: mysql-workbench-gpl < %version-%release

Provides: mysql-administrator = %version-%release
Obsoletes: mysql-administrator < %version-%release

Provides: mysql-query-browser = %version-%release
Obsoletes: mysql-query-browser < %version-%release

# "_mforms" and "grt" are accessable from "MySQL Workbench GRT Shell" only.
%add_python3_req_skip _mforms grt mforms

# internal Workbench's libraries
%add_python3_req_skip wb workbench cairo_utils wb_common

# for p9 compatibility
%ifdef add_python_req_skip
%add_python_req_skip _mforms grt mforms
%add_python_req_skip wb workbench cairo_utils wb_common
%endif
BuildRequires(pre): rpm-build-ninja
BuildRequires(pre): rpm-build-python3

%add_python3_req_skip workbench.change_tracker workbench.client_utils workbench.db_driver
%add_python3_req_skip workbench.db_utils workbench.exceptions workbench.graphics.cairo_utils
%add_python3_req_skip workbench.graphics.canvas workbench.graphics.charting workbench.log
%add_python3_req_skip workbench.notifications workbench.os_utils workbench.plugins
%add_python3_req_skip workbench.tcp_utils workbench.template workbench.ui workbench.utils

# shell_snippets.py is not pure Python
%add_findreq_skiplist */mysql-workbench/shell_snippets.py

# rpm-build 4.0.4.181-alt1: "library not found" warnings to errors
%add_findreq_skiplist */mysql-workbench/*.so
%add_findreq_skiplist */mysql-workbench/*.so.*
%add_findreq_skiplist */bin/mysql-workbench-bin
%add_findreq_skiplist */bin/wbcopytables-bin

# templates only
%add_findreq_skiplist */mysql-workbench/script_templates/*
%add_findreq_skiplist */mysql-workbench/libraries/grt_python_debugger.py

%add_python3_path %_libdir/mysql-workbench/modules
# https://bugzilla.altlinux.org/show_bug.cgi?id=48953#c3
%filter_from_provides /python3(cairo)/d

%set_verify_elf_method unresolved=relaxed

Requires: mysql-client gnome-keyring
Requires: %name-data = %version

# due /usr/lib64/libSegFault.so
# see https://bugzilla.altlinux.org/35600
Requires: glibc-devel

BuildRequires(pre): unzip
BuildRequires(pre): rpm-build-xdg

# MySQL only
BuildRequires: libmysqlclient-devel
BuildConflicts: libmariadb-devel

BuildRequires: boost-devel gcc-c++
BuildRequires: liblua5-devel libpcre-devel libsqlite3-devel libxml2-devel libzip-devel

BuildRequires: boost-signals-devel

BuildRequires: libGL-devel
BuildRequires: libctemplate-devel
BuildRequires: libiodbc-devel

# 6.3.4
BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake
BuildRequires: libXdmcp-devel libXdamage-devel libXxf86vm-devel
BuildRequires: swig libgdal-devel libpcrecpp-devel libpixman-devel libexpat-devel libvsqlite++-devel
BuildRequires: libgnome-keyring-devel libharfbuzz-devel libxshmfence-devel tinyxml-devel

# 6.3.8
BuildRequires: boost-locale-devel

# 6.3.10
BuildRequires: libgtk+3-devel wayland-protocols libxkbcommon-devel libgtkmm3-devel libproj-devel
BuildRequires: mysql-connector-c++-devel >= 1.1.9

# 6.3.10 antlr-3.4-complete.jar
BuildRequires: stringtemplate

# 8.0.15
BuildRequires: libdrm-devel libsecret-devel libssl-devel libfribidi-devel libmount-devel libblkid-devel
BuildRequires: libtiff-devel libpng-devel libepoxy-devel

# 8.0.19
BuildRequires: libthai-devel libdatrie-devel rapidjson

# 8.0.20
BuildRequires: libbrotli-devel libgcrypt-devel libuuid-devel

# 8.0.25
BuildRequires: libssh-devel >= 0.9.5
BuildRequires: libffi-devel bzlib-devel libselinux-devel
BuildRequires: libXinerama-devel libXi-devel libXrandr-devel libXcursor-devel
BuildRequires: libXcomposite-devel libwayland-cursor-devel libwayland-egl-devel
BuildRequires: at-spi2-atk-devel libdbus-devel libat-spi2-core-devel libXtst-devel

BuildRequires: python3-dev
BuildRequires: libantlr4-devel

# 8.0.33 antlr-4.11.1-complete.jar
BuildRequires: java-21-openjdk

# Runtime dependencies
Requires: libpcrecpp3 libmysqlcppconn7 libantlr4 libvsqlite++ libgdal%gdal_version

%description
MySQL Workbench is modeling tool that allows you to
design and generate MySQL databases graphically.

Some parts of code have separate licenses.
Look to %_defaultdocdir/%name-%version/License.txt

%package data
Summary: Architecture independent files for %name
License: GPL-2.0-or-later and LGPL-2.0-or-later and CC-BY-3.0 and MIT and Scintilla and Public-Domain
Group: Development/Databases
BuildArch: noarch
Conflicts: %name < %version
Conflicts: mysql-workbench-gpl-data

Requires: icon-theme-hicolor

%description data
Architecture independent files for %name

Some parts of code have separate licenses.
Look to %_defaultdocdir/%name-%version/License.txt

%ifarch loongarch64
# LTO triggers assertion in ld on LoongArch
%define optflags_lto %nil
%endif

%prep
%setup
%patch0 -p1
%patch1 -p2
%patch2 -p1
%patch3 -p1
%patch4 -p2
%patch5 -p1

sed -i "s|ldconfig|/sbin/ldconfig|" frontend/linux/workbench/mysql-workbench.in

#8.0.17: http://bugs.mysql.com/97116
sed -i "s/ -Werror//" CMakeLists.txt

#8.0.19: https://lists.altlinux.org/pipermail/devel/2020-March/210126.html
sed -i "s/ -Wno-deprecated-copy//g" CMakeLists.txt

# Fix building with python3.12 https://docs.python.org/3/whatsnew/3.12.html#id10
sed -i "/token.h/d" library/grt/src/python_context.cpp

%build

%ifarch %ix86
%add_optflags -Wno-error=format=
%endif

#8.0.17: wb_context_ui_home.cpp:59:10: fatal error: include <zip.h>
%add_optflags -I/usr/include/libzip
# 8.0.32: grtpp_shell.cpp, grt_string_list_model.cpp, db_sql_editor_history_be.cpp
# wb_sql_editor_tree_controller.cpp, wb_sql_editor_help.cpp, module_db_mysql.cpp,
# fatal error: include <pcre.h>
# 8.0.32: wb_sql_editor_help.cpp: fatal error: include <pcrecpp.h>
%add_optflags -I/usr/include/pcre

%cmake -GNinja \
    -DCMAKE_BUILD_TYPE=Release \
    -DCMAKE_INSTALL_RPATH=%_libdir/mysql-workbench \
    -DCMAKE_SKIP_INSTALL_RPATH=FALSE \
    -DWITH_ANTLR_JAR=%SOURCE1 \
#

#%%cmake_build
%ninja_build -C "%_cmake__builddir"

%install
#%%cmake_install
%ninja_install -C "%_cmake__builddir"

mkdir -p %buildroot%_niconsdir
cp %_builddir/%name-%version/images/icons/MySQLWorkbench-32.png %buildroot%_niconsdir/mysql-workbench.png

mkdir -p %buildroot%_iconsdir/hicolor/32x32/mimetypes
cp %_builddir/%name-%version/images/icons/MySQLPlugin-32.png %buildroot%_iconsdir/hicolor/32x32/mimetypes/application-vnd.mysql-workbench-plugin.png
cp %_builddir/%name-%version/images/icons/MySQLWorkbenchDocIcon32x32.png %buildroot%_iconsdir/hicolor/32x32/mimetypes/application-vnd.mysql-workbench-model.png

# Remove unused stuff
rm -f %buildroot%_datadir/mysql-workbench/extras/build_freetds.sh

%files
#exclude %_libdir/mysql-workbench/modules/*.py?

%exclude %_datadir/applications/*.desktop
%exclude %_datadir/mysql-workbench/*

%doc License.txt README.md AUTHORS
%exclude %_datadir/doc/mysql-workbench-community/License.txt
%exclude %_datadir/doc/mysql-workbench-community/README.md

%_bindir/mysql-workbench
%_bindir/mysql-workbench-bin
%_bindir/wbcopytables
%_bindir/wbcopytables-bin
%dir %_libdir/mysql-workbench
%_libdir/mysql-workbench/*

%files data
%_datadir/applications/*.desktop
%dir %_datadir/mysql-workbench
%_datadir/mysql-workbench/*
%_miconsdir/*
%_niconsdir/*
%_liconsdir/*
%_iconsdir/hicolor/128x128/apps/*
%_iconsdir/hicolor/16x16/mimetypes/*
%_iconsdir/hicolor/32x32/mimetypes/*
%_iconsdir/hicolor/48x48/mimetypes/*
%_iconsdir/hicolor/128x128/mimetypes/*
%_xdgmimedir/packages/*.xml
%_xdgdatadir/mime-info/*.mime

%changelog
