%def_disable snapshot
%define ver_major 4.0
%define beta %nil

%def_enable docs

Name: nautilus-python
Version: %ver_major.1
Release: alt1%beta

Summary: Python bindings for Nautilus
Group: Development/Python3
License: GPL-2.0-or-later
Url: https://www.gnome.org/

Provides: python-module-nautilus = %version-%release
Obsoletes: python-module-nautilus

Requires: typelib(Nautilus) = 4.0

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version%beta.tar
%endif

%define ext_api_ver 4
%define nautilus_extdir %_libdir/nautilus/extensions-%ext_api_ver
%define _pkgconfigdir %_datadir/pkgconfig

%add_python3_path %nautilus_extdir

%define nautilus_ver 43
%define pygobject_ver 3.0

BuildRequires(pre): rpm-macros-meson rpm-build-gnome rpm-build-python3 rpm-build-gir
BuildRequires: meson
BuildRequires: pkgconfig(libnautilus-extension-%ext_api_ver) >= %nautilus_ver libnautilus-gir-devel
BuildRequires: python3-devel python3-module-pygobject3-devel >= %pygobject_ver
%{?_enable_docs:BuildRequires: gtk-doc}

%description
This package provides Python bindings for the Nautilus extension library.

%package devel
Summary: Development files for %name
Group: Development/Python3
BuildArch: noarch
Requires: %name = %EVR
Provides: python-module-nautilus-devel = %EVR
Obsoletes: python-module-nautilus-devel

%description devel
Development files for %name.

%package devel-doc
Summary: Development documentation for %name
Group: Development/Python3
BuildArch: noarch
Conflicts: %name-devel < %version
Provides: python-module-nautilus-devel-doc = %EVR
Obsoletes: python-module-nautilus-devel-doc

%description devel-doc
Development documentation for %name.

%prep
%setup -n %name-%version%beta

%build
%meson \
    %{?_enable_docs:-Ddocs=enabled}
%nil
%meson_build

%install
%meson_install
mkdir -p %buildroot%_datadir/nautilus-python/extensions/__pycache__

%files
%nautilus_extdir/lib%name.so
%dir %_datadir/nautilus-python/extensions
%dir %_datadir/nautilus-python/extensions/__pycache__

%files devel
%_pkgconfigdir/%name.pc
%doc README* AUTHORS NEWS* examples

%if_enabled docs
%files devel-doc
%_datadir/gtk-doc/html/*
%endif

%exclude %_docdir/%name

%changelog
