Name: ncurses
Version: 6.3.20220618
Release: alt4

%define rootdatadir /lib

Summary: A CRT screen handling and optimization package
License: MIT
Group: System/Base
Url: https://invisible-island.net/ncurses/

# ftp://invisible-island.net/%name/%name-%version.tar.gz
Source: %name-%version.tgz

Source100: %name-alt-terms.tar
Source101: %name-baseterms
Source102: %name-resetall.sh

Patch: ncurses-alt.patch

Obsoletes: ncurses3
Requires: termutils-devel = %version-%release

#build parameters
%def_with utf8
%def_with shared
%def_with normal
%def_without debug
%def_without profile
%def_with cxx
%def_with gpm
%def_without ada
%def_without libtool

# Automatically added by buildreq on Thu Nov 12 2009
BuildRequires: gcc-c++

%if_with gpm
BuildRequires: libgpm-devel gcc-c++
%endif

%define ncurses_descr\
The curses library routines are a terminal-independent method of updating\
character screens with reasonable optimization.  The %name (new curses)\
library is a freely distributable replacement for the discontinued 4.4BSD\
classic curses library.

%define terminfo_descr\
Terminfo is a data base describing terminals, used by screen-oriented\
programs and libraries such as curses(3X).  Terminfo describes terminals\
by giving a set of capabilities which they have, by specifying how to\
perform screen operations, and by specifying padding requirements and\
initialization sequences.

%define ABI 6
%define OLDSO 5
# define OLDABI to OLDSO when ABI increases, it's nil for now
#define OLDABI %%OLDSO
%define libpackage(od:s)\
%global libpkgname lib%{!-d:%{1}%{!?-o:%ABI}%{?-o:%{?OLDABI}}}%{-d:%{1}-devel%{-s:-static}}\
%global libsummary %{?-o: legacy}%{-d:%{-s: static} development environment}\
%%package -n %libpkgname\
Group: %{!?-o:%{?-d:Development/%{-d*}}}%{!?-o:%{!?-d:System/Libraries}}%{?-o:System/Legacy libraries}\
%{expand:%%{?libpackage_extra}}\
Summary: Ncurses %* library%libsummary\
%%description -n %libpkgname\
%ncurses_descr\
\
This package contains %* library%libsummary\
%undefine libpackage_extra\
%nil

%define libpackage_extra Requires(pre,postun): terminfo = %EVR
%libpackage tinfo low-level terminfo
%libpackage -o tinfo low-level terminfo
%libpackage -dC tinfo low-level terminfo
%libpackage -sdC tinfo low-level terminfo

%libpackage tic terminfo manipulation
%libpackage -o tic terminfo manipulation
%libpackage -dC tic terminfo manipulation

%define libpackage_extra Provides: %name = %EVR
%libpackage %name base
%libpackage -o %name base
%define libpackage_extra Provides: %{name}-devel = %EVR
%libpackage -dC %name base
%libpackage -sdC %name base

%libpackage %{name}++ C++ bindings
%libpackage -o %{name}++ C++ bindings
%libpackage -dC++ %{name}++ C++ bindings
%libpackage -sdC++ %{name}++ C++ bindings

%if_with utf8
%define libpackage_extra Provides: %{name}w = %EVR
%libpackage %{name}w base library (widechar support)
%libpackage -o %{name}w base (widechar support)
%define libpackage_extra Requires: lib%{name}-devel = %EVR\
Provides: %{name}w-devel = %EVR
%libpackage -dC %{name}w base (widechar support)
%libpackage -sdC %{name}w base (widechar support)

%libpackage %{name}++w C++ bindings (widechar support)
%libpackage -o %{name}++w C++ bindings (widechar support)
%define libpackage_extra Requires: lib%{name}w-devel = %EVR\
Requires: lib%{name}++-devel = %EVR
%libpackage -dC++ %{name}++w C++ bindings (widechar support)
%libpackage -sdC++ %{name}++w C++ bindings (widechar support)
%endif


%package -n terminfo
Summary: Descriptions of common terminal types
Group: System/Base
Conflicts: %name < %version-%release
Conflicts: screen < 3.9.11-alt1
BuildArch: noarch

%package -n terminfo-extra
Summary: Additional terminal type definitions
Group: System/Base
BuildArch: noarch
Provides: %name-extraterms = %version
Obsoletes: %name-extraterms
Requires(pre,postun): terminfo = %version-%release

%package -n termutils
Summary: Basic terminal utilities
Group: System/Base
Provides: /bin/tput

%package -n termutils-devel
Summary: Additional terminal utilities
Group: Development/Other
Requires: termutils = %version-%release

%description
%ncurses_descr

%description -n terminfo
%terminfo_descr

This package contains what should be a reasonable subset of terminal
definitions, including: ansi, dumb, linux, rxvt, screen, sun, vt100,
vt102, vt220, vt52, and xterm.

%description -n terminfo-extra
%terminfo_descr

This package contains all of the terminal definitions not found in
the terminfo package.  There are far too many to list here.

%description -n termutils
%ncurses_descr

This package contains basic terminal manipulation utilities.

%description -n termutils-devel
%ncurses_descr

This package contains additional terminal manipulation utilities.

%prep
%setup -a100

%patch -p1

sed -i 's/EXTRA_LIBS="-ldl -lncurses $EXTRA_LIBS"/EXTRA_LIBS="$EXTRA_LIBS"/
s/SHLIB_LIST="-ldl $SHLIB_LIST"/SHLIB_LIST="-lgpm $SHLIB_LIST"/
s/TINFO_LIST="$SHLIB_LIST"/TINFO_LIST=/' ./configure

xz -9k NEWS

%build
%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}
%remove_optflags %optflags_notraceback %optflags_nocpp
%ifarch %ix86
%add_optflags -momit-leaf-frame-pointer
%endif

# Predefine these for configure:
export \
	ac_cv_func_mkstemp=yes \
	ac_cv_prog_AWK=gawk \
	ac_cv_prog_MAKE_LOWER_TAGS=yes \
	ac_cv_prog_MAKE_UPPER_TAGS=yes \
	ac_cv_prog_MAN=man \
        %nil

%define _configure_script ../configure

%define configopts --program-transform-name= \\\
	%{subst_with shared} \\\
	%{subst_with normal} \\\
	%{subst_with debug} \\\
	%{subst_with profile} \\\
	%{subst_with ada} \\\
	%{subst_with libtool} \\\
	%{subst_with gpm} \\\
        %if_with cxx \
	--with-cxx-shared \\\
        %endif \
	--without-dlsym \\\
	--with-termlib=tinfo \\\
	--with-ticlib=tic \\\
	--with-ospeed="unsigned int" \\\
	--with-terminfo-dirs="%rootdatadir/terminfo:%_datadir/terminfo" \\\
	--disable-termcap \\\
	--enable-const \\\
	--enable-hard-tabs \\\
	--enable-no-padding \\\
	--enable-sigwinch \\\
	--enable-echo \\\
	--enable-warnings \\\
	--with-pkg-config-libdir=%_pkgconfigdir \\\
	--disable-rpath \\\
	--disable-root-environ \\\
	--disable-home-terminfo \\\
        --disable-stripping \\\
	--with-chtype=long \\\
        %nil

%define abi5opts --with-abi-version=%OLDSO --disable-pc-files
%define abi6opts --enable-pc-files

%define configure_flavour(d:) mkdir -p build-%{-d*} && cd build-%{-d*} && %configure %configopts %* && cd ..

# configure classic version
%configure_flavour -d classic5 -- %abi5opts
%make_build -C build-classic5
%configure_flavour -d classic -- %abi6opts
%make_build -C build-classic
%if_with utf8
%configure_flavour -d utf85 -- --enable-widec %abi5opts
%make_build -C build-utf85
%configure_flavour -d utf8 -- --enable-widec %abi6opts
%make_build -C build-utf8
%endif # with_utf8

%install
#install classic ncurses library version
%makeinstall_std -C build-classic5 includedir=%_includedir/%name
%makeinstall_std -C build-classic includedir=%_includedir/%name

%if_with utf8
%makeinstall_std -C build-utf85 includedir=%_includedir/%name
find build-utf8 | xargs touch
%makeinstall_std -C build-utf8 includedir=%_includedir/%name
ln -rs %buildroot%_includedir/%name %buildroot%_includedir/%{name}w
%endif # with_utf8

# The resetall script.
install -pD -m755 %SOURCE102 %buildroot%_bindir/resetall

ln -snf %name/curses.h %buildroot%_includedir/%name.h
for n in curses eti form menu panel term termcap unctrl; do
	ln -snf "%name/$n.h" "%buildroot%_includedir/$n.h"
done

# Relocate libtinfo from _libdir/ to /_lib/.
for f in %buildroot%_libdir/libtinfo*.so; do
	t=$(readlink "$f")
	ln -snf "$(relative /%_lib/"$t" %_libdir/)" "$f"
done
mkdir -p %buildroot/%_lib
mv %buildroot%_libdir/libtinfo*.so.* %buildroot/%_lib/

ln -snf lib%name.so %buildroot%_libdir/libcurses.so

# Library compatibility symlinks.
t=$(readlink "%buildroot%_libdir/lib%name.so.%OLDSO")
for v in 4 3; do
	ln -s "$t" "%buildroot%_libdir/lib%name.so.$v"
done

# Relocate tput.
mkdir -p %buildroot/bin
mv %buildroot%_bindir/tput %buildroot/bin/
ln -s ../../bin/tput %buildroot%_bindir/

# Generate new terminfo entries (deb).
for n in rxvt rxvt-unicode screen; do
	LD_LIBRARY_PATH=%buildroot/%_lib:%buildroot%_libdir \
        TERMINFO=%buildroot%_datadir/terminfo \
		%buildroot%_bindir/tic -s %name-alt-terms/$n.ti
done

# Split terminfo entries into /lib/terminfo and %_datadir/terminfo.
ln -snf ../l/linux %buildroot%_datadir/terminfo/c/console

rm -f relocation_error
while read -r n; do
	f="${n:0:1}"
	mkdir -p "%buildroot/%rootdatadir/terminfo/$f"
	mv "%buildroot%_datadir/terminfo/$f/$n" "%buildroot/%rootdatadir/terminfo/$f/" ||
		{ touch relocation_error; exit 1; }
	ln -s `relative "%buildroot/%rootdatadir/terminfo/$f/$n" "%buildroot%_datadir/terminfo/$f/"` \
		"%buildroot%_datadir/terminfo/$f/" ||
		{ touch relocation_error; exit 1; }
	echo "%%dir %_datadir/terminfo/$f"
	echo "%_datadir/terminfo/$f/$n"
done < %SOURCE101 | sort -u > base.list
[ ! -f relocation_error ]

find %buildroot%_datadir/terminfo -type f -mindepth 2 |
	sed "s|%buildroot||g" > extra.list

# Remove /usr/lib/terminfo if any.
rm -f %buildroot/usr/lib/terminfo

# Prepare docs.
rm -rf %buildroot%_docdir/%name-%version
mkdir -p %buildroot%_docdir/%name-%version
install -pm644 ANNOUNCE NEWS.xz README TO-DO \
	c++/demo.cc doc/*.doc doc/html/*.html \
	%buildroot%_docdir/%name-%version/
install -pm644 c++/README-first \
	%buildroot%_docdir/%name-%version/README.c++
#make clean -C test

# Replace libncurses.so/libncursesw.so symlinks with linker scripts.
for i in ncurses ncursesw; do
	rm -f %buildroot%_libdir/lib$i.so
	cat > %buildroot%_libdir/lib$i.so <<-EOF
	/* GNU ld script */
	GROUP(%_libdir/lib$i.so.%ABI -ltinfo)
	EOF
done

%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

%files
# ncurses is a pure virtual package.

# TERMINFO
%files -n terminfo -f base.list
%rootdatadir/terminfo
%dir %_datadir/terminfo/
%_datadir/tabset
%_man5dir/*

%files -n terminfo-extra -f extra.list
%dir %_datadir/terminfo/
%dir %_datadir/terminfo/*
%_datadir/terminfo/c/console

# LIBTINFO
%files -n libtinfo%ABI
/%_lib/libtinfo.so.%{ABI}*

%files -n libtinfo%{?OLDABI}
/%_lib/libtinfo.so.*
%exclude /%_lib/libtinfo.so.%{ABI}*

%files -n libtinfo-devel
%_libdir/libtinfo.so
%_includedir/termcap.h
%_includedir/term.h
%_pkgconfigdir/tinfo.pc
%dir %_includedir/%name/
%_includedir/%name/termcap.h
%_includedir/%name/term.h
%_includedir/%name/ncurses_dll.h

%files -n libtinfo-devel-static
%_libdir/libtinfo.a

%files -n libtic%ABI
%_libdir/libtic.so.%{ABI}*

%files -n libtic%{?OLDABI}
%_libdir/libtic.so.*
%exclude %_libdir/libtic.so.%{ABI}*

%files -n libtic-devel
%_libdir/libtic.so
%_pkgconfigdir/tic.pc
%_includedir/%name/term_entry.h
%_includedir/%name/nc_tparm.h

# TERMUTILS
%files -n termutils
/bin/tput
%_bindir/clear
%_bindir/infocmp
%_bindir/reset*
%_bindir/toe
%_bindir/tput
%_bindir/tset
%_bindir/tabs
%_man7dir/*
%_man1dir/clear.*
%_man1dir/infocmp.*
%_man1dir/reset.*
%_man1dir/toe.*
%_man1dir/tput.*
%_man1dir/tset.*
%_man1dir/tabs.*

%files -n termutils-devel
%_bindir/captoinfo
%_bindir/infotocap
#_bindir/tack
%_bindir/tic
%_man1dir/captoinfo.*
%_man1dir/infotocap.*
#_man1dir/tack.*
%_man1dir/tic.*

# LIBNCURSES
%files -n lib%name%ABI
%_libdir/lib*[musl].so.%{ABI}*
%dir %_docdir/%name-%version/
%_docdir/%name-%version/[A-Z]*

%files -n lib%{name}%{?OLDABI}
%exclude %_libdir/lib*[musl].so.%{ABI}*
%_libdir/lib*[musl].so.*

%files -n lib%name-devel
%_bindir/%{name}*%ABI-config
%exclude %_bindir/%{name}%OLDSO-config
%_libdir/lib*[musl].so
%_pkgconfigdir/*[musl].pc
%_includedir/*
%_man1dir/*-config*
%exclude %_includedir/term*.h
%exclude %_includedir/%name/term*.h
%exclude %_includedir/%name/ncurses_dll.h
%exclude %_includedir/%name/nc_tparm.h
%if_with cxx
%exclude %_includedir/%name/cursesapp.h
%exclude %_includedir/%name/curses?.h
%exclude %_includedir/%name/cursslk.h
%exclude %_includedir/%name/etip.h
%endif # with_cxx
%if_with utf8
%exclude %_includedir/%{name}w
%endif # with_utf8
%_man3dir/*
%dir %_docdir/%name-%version/
%_docdir/%name-%version/[a-z]*

%files -n lib%name-devel-static
%_libdir/lib*.a
%exclude %_libdir/libtinfo.a
%if_with cxx
%exclude %_libdir/libncurses++*.a
%endif # with_cxx

# LIBNCURSES++
%if_with cxx
%files -n lib%name++%ABI
%_libdir/libncurses++.so.%{ABI}*

%files -n lib%name++%{?OLDABI}
%_libdir/libncurses++.so.%{OLDSO}*

%files -n lib%name++-devel
%_libdir/libncurses++.so
%dir %_includedir/%name/
%_includedir/%name/cursesapp.h
%_includedir/%name/curses?.h
%_includedir/%name/cursslk.h
%_includedir/%name/etip.h
%_pkgconfigdir/ncurses++.pc

%files -n lib%name++-devel-static
%_libdir/libncurses++.a
%endif # with_cxx

%if_with utf8
%files -n lib%{name}w%ABI
%_libdir/lib*[musl]w.so.%{ABI}*

%files -n lib%{name}w%{?OLDABI}
%exclude %_libdir/lib*[musl]w.so.%{ABI}*
%_libdir/lib*[musl]w.so.*

%files -n lib%{name}w-devel
%_bindir/%{name}w5-config
%_libdir/lib*[musl]w.so
%_includedir/%{name}w
%_pkgconfigdir/*[musl]w.pc

%if_with cxx
%files -n lib%{name}++w%ABI
%_libdir/libncurses++w*.so.%{ABI}*

%files -n lib%{name}++w%{?OLDABI}
%_libdir/libncurses++w*.so.%{OLDSO}*

%files -n lib%{name}++w-devel
%_libdir/libncurses++w.so
%dir %_includedir/%name/
%_pkgconfigdir/ncurses++w*.pc

%files -n lib%name++w-devel-static
%_libdir/libncurses++w*.a
%endif # with_cxx
%endif # with_utf8

%changelog
