%define sover   1

Name:           nftables
Epoch:          1
Version:        1.1.5
Release:        alt1
Summary:        nftables is the project that aims to replace the existing {ip,ip6,arp,eb}tables framework
Group:          System/Libraries
License:        GPL-2.0-only
URL:            http://netfilter.org/projects/nftables
Requires:       lib%name%sover = %EVR
# git://git.netfilter.org/nftables
Source:        %name-%version.tar

BuildRequires: libmnl-devel libnftnl-devel flex bison libgmp-devel libreadline-devel asciidoc-a2x libjansson-devel
BuildRequires(pre): docbook2X rpm-build-python3 python3-devel python3-module-setuptools

%description
libnftnl is a userspace library providing a low-level netlink programming interface (API) to the
in-kernel nf_tables subsystem. The library libnftnl has been previously known as libnftables.
This library is currently used by nftables.

%package -n lib%name%sover
Summary: Library for %name
Group: System/Libraries
Provides: lib%name = %EVR
Obsoletes: lib%name < %EVR


%description -n lib%name%sover
This package contains shared libraries used by %name.

%package -n lib%name-devel
Summary: Development package that includes the %name header files
Group: Development/C
Requires: lib%name%sover = %EVR

%description -n lib%name-devel
The devel package contains the include files

%package -n python3-module-%name
Summary: Python3 modules and extensions for %name
Group: Development/Python3
BuildArch: noarch

%description -n python3-module-%name
Python3 modules and extensions for %name

%prep
%setup

## py2 -> py3
sed -i 's|#!/usr/bin/env python|#!/usr/bin/env python3|' \
    $(find ./ -name '*.py')
sed -i 's|#!/usr/bin/python|#!/usr/bin/python3|' \
    $(find ./ -name '*.py')
##

%build
%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}

%autoreconf
%configure --enable-debug \
	   --enable-python \
	   --with-python-bin=/usr/bin/python3 \
	   --with-json \
	   --with-cli=readline
%make_build

%check
make check

%install
%makeinstall_std

( cd py && python3 setup.py install --root=%buildroot --prefix=%_prefix)

#mkdir -p %buildroot%_sysconfdir/nftables
install -dm0755 %buildroot%_docdir/%name
install -pDm0644 nftables.nft %buildroot%_sysconfdir/nftables/nftables.nft
install -dm0755 %buildroot%_unitdir
install -pDm0644 nftables.service %buildroot%_unitdir/nftables.service

%post
%post_service nftables

%files
%doc COPYING files/examples/*.nft files/nftables/*.nft
%dir %_sysconfdir/nftables
%dir %_sysconfdir/nftables/osf
%_sysconfdir/nftables/osf/*
%attr(644,root,root) %config %_sysconfdir/nftables/*.nft
%_unitdir/*
%_sbindir/*
%_man8dir/*

%files -n lib%name%sover
%_libdir/lib%name.so.*

%files -n lib%name-devel
%_includedir/*
%_libdir/lib%name.so
%_libdir/pkgconfig/*
%_man3dir/*
%_man5dir/*

%files -n python3-module-%name
%python3_sitelibdir_noarch/*

%changelog
