%def_with kerberos5

Name: nxssh
Version: 7.5
Release: alt14

Summary: Openssh portable (Etersoft edition) for using with NX in RX@Etersoft

License: GPL, MIT/X11 for X11 bits
Group: Networking/Remote access
Url: https://github.com/openssh/openssh-portable

Packager: Pavel Vainerman <pv@altlinux.ru>

# Source-git: https://github.com/openssh/openssh-portable.git
Source: %name-%version.tar

Patch1: 0001-fix-openssl-1.1.patch-eterbug-12901.patch

Requires: nx-libs >= 3.5.0.31

BuildRequires: libpam-devel libssl-devel nx-libs-devel openssh-clients

%if_with kerberos5
BuildRequires: libkrb5-devel
%endif

%description
Openssh portable (Etersoft edition) for using with NX in RX@Etersoft.

%prep
%setup

# fix build with openssl >= 1.1
if [ ! -s %_libdir/libssl.so.1.0.* ] || [ ! -s /%_lib/libssl.so.1.0.* ] ; then
%patch1 -p1
fi

%build
# detect config placement
confdir=""
[ -r "/etc/openssh/ssh_config" ] && confdir="/openssh"
[ -r "/etc/ssh/ssh_config" ] && confdir="/ssh"
[ -r "/etc/ssh_config" ] && confdir="/"
%__subst "s|-DSSHDIR=\\\\\"\$(sysconfdir)\\\\\"|-DSSHDIR=\\\\\"\$(sysconfdir)${confdir}\\\\\"|g" Makefile.in

%autoreconf
%configure --without-zlib-version-check %{subst_with kerberos5}
%make_build || %make

echo "checking ssh config path"
grep -a "/etc${confdir}/ssh_config" nxssh

%install
mkdir -p %buildroot%_bindir/
install -m755 nxssh %buildroot%_bindir/

%files
%_bindir/nxssh

%changelog
