# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

%add_python3_path %_libdir/obs-scripting/
%add_python3_path %_datadir/obs/obs-plugins/frontend-tools/scripts/

%define websocket_version 5.5.6

Name: obs-studio
Summary: Free and open source software for video recording and live streaming
Summary(ru_RU.UTF-8): Свободная программа для записи и трансляции видеопотока
Version: 31.1.2
Release: alt1
License: GPL-2.0-or-later
Group: Video
Url: https://github.com/obsproject/obs-studio
Vcs: https://github.com/obsproject/obs-studio.git
Source: %name-%version.tar
Source1: obs-websocket-%websocket_version.tar

Patch: %name-%version-%release.patch

# https://bugzilla.altlinux.org/47318
Requires: qt6-svg

# https://bugzilla.altlinux.org/53023
Requires: pipewire

BuildRequires(pre): rpm-macros-cmake
BuildRequires(pre): rpm-macros-luajit
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
BuildRequires: ninja-build
BuildRequires: libjansson-devel
BuildRequires: cmake gcc-c++
BuildRequires: extra-cmake-modules
BuildRequires: libGL-devel libGLU-devel
BuildRequires: libX11-devel libxcb-devel
BuildRequires: libalsa-devel
BuildRequires: libjack-devel
BuildRequires: libpulseaudio-devel 
BuildRequires: qt6-base-devel
BuildRequires: qt6-svg-devel
BuildRequires: pkgconfig(MagickCore)
BuildRequires: texlive-latex-base
BuildRequires: zlib-devel
BuildRequires: libcurl-devel
BuildRequires: libx264-devel
BuildRequires: libv4l-devel
BuildRequires: libswscale-devel libswresample-devel
BuildRequires: libavutil-devel libavformat-devel libavdevice-devel libavfilter-devel libavcodec-devel
BuildRequires: libvlc-devel
BuildRequires: libpostproc-devel
BuildRequires: fontconfig-devel libfreetype-devel libpng-devel libexpat-devel
BuildRequires: systemd-devel libudev-devel
BuildRequires: pkgconfig(dbus-1)
BuildRequires: swig
BuildRequires: libspeexdsp-devel
BuildRequires: websocketpp-devel
BuildRequires: pkgconfig(wayland-egl)
BuildRequires: pkgconfig(wayland-server)
BuildRequires: pkgconfig(wayland-client)
BuildRequires: pkgconfig(wayland-cursor)
BuildRequires: pkgconfig(gio-2.0) >= 2.76
BuildRequires: pkgconfig(gio-unix-2.0)
BuildRequires: pkgconfig(libpci)
BuildRequires: pkgconfig(rnnoise)
BuildRequires: pipewire-libs-devel
BuildRequires: libdrm-devel
BuildRequires: libmbedtls-compat-devel
BuildRequires: libuuid-devel
BuildRequires: libfdk-aac-devel
BuildRequires: libdatachannel-devel
BuildRequires: libuthash-devel
BuildRequires: nv-codec-headers
BuildRequires: nlohmann-json-devel
%ifarch x86_64 aarch64
BuildRequires: libvpl-devel
%endif
BuildRequires: libqrcodegen-cpp-devel libqrcodegen-devel
BuildRequires: asio-devel
%ifarch %luajit_arches
BuildRequires: pkgconfig(luajit)
%endif

%add_python3_req_skip obspython

Obsoletes: %name-plugin-frontend-tools <= 0.26.0
Obsoletes: %name-plugin-image-source <= 0.26.0
Obsoletes: %name-plugin-alsa <= 0.26.0
Obsoletes: %name-plugin-capture <= 0.26.0
Obsoletes: %name-plugin-decklink <= 0.26.0
Obsoletes: %name-plugin-v4l2 <= 0.26.0
Obsoletes: %name-plugin-ffmpeg <= 0.26.0
Obsoletes: %name-plugin-filters <= 0.26.0
Obsoletes: %name-plugin-outputs <= 0.26.0
Obsoletes: %name-plugin-transitions <= 0.26.0
Obsoletes: %name-plugin-rtmp-services <= 0.26.0
Obsoletes: %name-plugin-freetype2 <= 0.26.0
Obsoletes: %name-plugin-vlc-video <= 0.26.0
Obsoletes: %name-plugin-x264 <= 0.26.0
Obsoletes: %name-plugin-jack <= 29.1.0
Obsoletes: %name-plugin-pulseaudio <= 29.1.0
Obsoletes: %name-plugin-pipewire <= 29.1.0
Obsoletes: %name-base <= 29.1.0

Provides: %name-base = %EVR

%description
Free and open source software for video recording and live streaming.

%description -l ru_RU.UTF-8
Свободная программа для записи и трансляции видеопотока.

%package -n libobs
Summary: Open Broadcaster Software Studio libraries
Group: Video

%description -n libobs
Library files for Open Broadcaster Software.

%package -n libobs-devel
Summary: Development files for %name
Group: Development/C
Requires: libobs = %EVR

%description -n libobs-devel
Development files for %name.

%prep
%setup -a1
%patch -p1
rmdir plugins/obs-websocket
mv obs-websocket-%websocket_version plugins/obs-websocket

%ifarch %e2k
# someone added this poorly written code to upstream
sed -i '/MATCHES "e2k"/c if(false)' cmake/Modules/CompilerConfig.cmake
%add_optflags -DSIMDE_ARCH_AMD64=1000 -mno-sse4.2
%endif
touch plugins/obs-{browser,websocket}/CMakeLists.txt

# rpmlint reports E: hardcoded-library-path
# replace OBS_MULTIARCH_SUFFIX by LIB_SUFFIX
#sed -i 's|OBS_MULTIARCH_SUFFIX|LIB_SUFFIX|g' cmake/Modules/ObsHelpers.cmake

# remove -Werror flag to mitigate FTBFS with ffmpeg 5.1
#sed -e 's|-Werror-implicit-function-declaration||g' -i cmake/Modules/CompilerConfig.cmake
#sed -e '/-Werror/d' -i cmake/Modules/CompilerConfig.cmake

# Removing unused third-party deps
rm -rv deps/w32-pthreads

# Remove unneeded EGL/KHR files
rm -rv deps/glad/include/{EGL,KHR}
sed -e 's|include/EGL/eglplatform.h||g' -i deps/glad/CMakeLists.txt

# disable unusable qsv plugin
mv plugins/obs-qsv11/CMakeLists.txt plugins/obs-qsv11/CMakeLists.txt.disabled
touch plugins/obs-qsv11/CMakeLists.txt

%build
%add_optflags -I%_sourcedir/%name-%version/libobs
%cmake \
	-DOBS_VERSION_OVERRIDE=%version \
	-DCMAKE_COMPILE_WARNING_AS_ERROR=OFF \
	-DUNIX_STRUCTURE=1 -GNinja \
	-DCMAKE_SKIP_RPATH=1 \
	-DWITH_RTMPS=ON \
	-DENABLE_BROWSER=OFF \
	-DENABLE_WEBRTC=OFF \
	-DBUILD_VST=OFF \
	-DENABLE_NEW_MPEGTS_OUTPUT=OFF \
	-DENABLE_AJA=OFF \
	-DENABLE_JACK=ON \
	-DENABLE_LIBFDK=ON \
%ifarch %luajit_arches
	-DENABLE_SCRIPTING_LUA=ON \
%else
	-DENABLE_SCRIPTING_LUA=OFF \
%endif
	-DOpenGL_GL_PREFERENCE=GLVND

%cmake_build

%install
%cmake_install

%files
%doc COPYING README.rst
%_bindir/*
%_datadir/obs/*
%exclude %_datadir/obs/libobs/
%_desktopdir/*.desktop
%_iconsdir/hicolor/*/apps/*.*
%_libdir/obs-scripting/
%_libdir/obs-plugins
%_datadir/metainfo/*

%files -n libobs
%dir %_datadir/obs
%_datadir/obs/libobs/
%_libdir/*.so.*
%_libdir/libobs-scripting.so

%files -n libobs-devel
%_includedir/obs/
%_libdir/*.so
%exclude %_libdir/libobs-scripting.so
%_libdir/cmake/libobs/
%_libdir/cmake/obs-frontend-api/
%_libdir/cmake/obs-websocket-api/
%_libdir/pkgconfig/libobs.pc
%_libdir/pkgconfig/obs-frontend-api.pc

%changelog
