%define libname ptime
Name: ocaml-%libname
Version: 1.2.0
Release: alt2
Summary: POSIX time for OCaml
License: ISC
Group: Development/ML
Url: http://erratique.ch/software/ptime
VCS:https://github.com/dbuenzli/ptime
Source: %name-%version.tar

BuildRequires: ocaml-findlib-devel ocaml-ocamlbuild-devel ocaml-topkg-devel ocaml >= 4.07.1 opam
BuildRequires: ocaml-compiler-libs

%package devel
Summary: Development files for programs which will use the BOS library
Group: Development/ML
Requires: %name = %EVR

%description
Ptime has platform independent POSIX time support in pure OCaml. It provides
a type to represent a well-defined range of POSIX timestamps with picosecond
precision, conversion with date-time values, conversion with RFC 3339 timestamps
and pretty printing to a human-readable, locale-independent representation.

The additional Ptime_clock library provides access to a system POSIX clock and
to the system's current time zone offset.

%description devel
This package includes development files necessary for developing
programs which use %name

%prep
%setup

%build
ocaml pkg/pkg.ml build --dev-pkg false --tests true

%install
sed -i 's,%%%%VERSION_NUM%%%%,%version,g' pkg/META
opam-installer --prefix=%buildroot%prefix --libdir=%buildroot%_libdir/ocaml

%ocaml_find_files

%check
ocaml pkg/pkg.ml test

%files -f ocaml-files.runtime
%doc LICENSE.md CHANGES.md README.md

%files devel -f ocaml-files.devel

%changelog
