%def_with check
%define docdir %_docdir/%name-%version
%define module sqlite3
Name: ocaml-%module
Version: 5.2.0
Release: alt1
Summary: OCaml library for accessing SQLite3 databases
License: MIT
Group: Development/ML
Url: https://mmottl.github.io/sqlite3-ocaml/
VCS: https://github.com/mmottl/sqlite3-ocaml
Source: %name-%version.tar

BuildRequires: libsqlite3-devel ocaml-dune-configurator-devel rpm-build-ocaml
%if_with check
BuildRequires: ocaml-ppx_inline_test-devel
BuildRequires: ocaml-ppx_enumerate-devel
BuildRequires: ocaml-ppx_compare-devel
BuildRequires: ocaml-ppx_sexp_conv-devel
BuildRequires: ocaml-ppx_hash-devel
%endif
Provides: ocaml4-%module
Obsoletes: ocaml4-%module
Obsoletes: ocaml-%module-runtime < %EVR

%description
SQLite 3 database library wrapper for OCaml.

%package devel
Summary: Development files for %name 
Group: Development/ML
Requires: %name = %EVR

%description devel
The %name-devel package contains libraries and signature files for
developing applications that use %name.

%prep
%setup -q 

%build
%dune_build -p %module

%install
%dune_install

%check
%dune_check

%files -f ocaml-files.runtime
%doc LICENSE.md CHANGES.md README.md TODO.md

%files devel -f ocaml-files.devel

%changelog
