%define oname   topkg
Name: ocaml-topkg
Version: 1.0.7
Release: alt1
Summary: The transitory OCaml software packager
License: ISC
Group: Development/ML
Url: https://erratique.ch/software/topkg
VCS: https://github.com/dbuenzli/topkg
Source0: %name-%version.tar
BuildRequires: opam
BuildRequires: ocaml-findlib-devel
BuildRequires: ocaml-result-devel
BuildRequires: ocaml-ocamlbuild
BuildRequires: rpm-build-ocaml >= 1.6

%description
Topkg is a packager for distributing OCaml software. It provides
an API to describe the files a package installs in a given build
configuration and to specify information about the package's
distribution, creation and publication procedures.

The optional topkg-care package provides the topkg command line
tool which helps with various aspects of a package's life cycle:
creating and linting a distribution, releasing it on the WWW,
publish its documentation, add it to the OCaml opam repository,
etc.

%package devel
Summary: Development files for %name
Group: Development/ML
Requires: %name = %EVR

%description devel
The %name-devel package contains libraries and signature files for
developing applications that use %name.

%prep
%setup

%build
sed -i 's,%%%%VERSION_NUM%%%%,%version,g;s,result,,g' pkg/META
ocaml pkg/pkg.ml "build"


%install
opam-installer \
	--prefix=%buildroot%prefix \
	--libdir=%buildroot%_libdir/ocaml \
	%oname.install

# remove bogus path of docs
rm -rf %buildroot%prefix/doc/%oname

%ocaml_find_files

%files -f ocaml-files.runtime
%doc README.md CHANGES.md LICENSE.md

%files devel -f ocaml-files.devel
%doc doc/ test/

%changelog
