%def_enable check

Name: odfpy
Version: 1.4.1
Release: alt1.1
Summary: Python scripts for manipulating OpenDocument files

Group: Development/Python3
License: GPLv2+
Url: https://joinup.ec.europa.eu/software/odfpy/home

# Source-url: https://pypi.io/packages/source/o/%name/%name-%version.tar.gz
Source: %name-%version.tar.gz

BuildArch: noarch

BuildRequires: rpm-build-python3
%{?_enable_check:BuildRequires: python3-module-pytest python3-module-defusedxml}

Conflicts: python3-module-odf < %EVR
Obsoletes: python3-module-odf < %EVR

%description
    csv2odf - Create OpenDocument spreadsheet from comma separated values
    mailodf - Email ODF file as HTML archive
    odf2xhtml - Convert ODF to (X)HTML
    odf2mht - Convert ODF to HTML archive
    odf2xml - Create OpenDocument XML file from OD? package
    odfimgimport - Import external images
    odflint - Check ODF file for problems
    odfmeta - List or change the metadata of an ODF file
    odfoutline - Show outline of OpenDocument
    odfuserfield - List or change the user-field declarations in an ODF file
    xml2odf - Create OD? package from OpenDocument in XML form

%package -n python3-module-%name
Summary: Python3 library for manipulating OpenDocument files
Group: Development/Python3
License: GPLv2+

%add_python3_self_prov_path %buildroot%python3_sitelibdir/odf/

%description -n python3-module-%name
Odfpy aims to be a complete API for OpenDocument in Python. Unlike
other more convenient APIs, this one is essentially an abstraction
layer just above the XML format. The main focus has been to prevent
the programmer from creating invalid documents. It has checks that
raise an exception if the programmer adds an invalid element, adds an
attribute unknown to the grammar, forgets to add a required attribute
or adds text to an element that doesn't allow it.

These checks and the API itself were generated from the RelaxNG
schema, and then hand-edited. Therefore the API is complete and can
handle all ODF constructions, but could be improved in its
understanding of data types.

%prep
%setup -n %name-%version

%build
%python3_build

%install
%python3_install

%check
export PYTHONPATH=$PWD
py.test3

%files
%doc README*
%_bindir/*
%_man1dir/*

%files -n python3-module-%name
%doc examples
%doc contrib
%doc *odt
%python3_sitelibdir/*egg-info
%python3_sitelibdir/odf/

%changelog
