# SPDX-License-Identifier: GPL-2.0-only
%define _unpackaged_files_terminate_build 1

Name: ollama-python
Version: 0.5.3
Release: alt1
Summary: Ollama Python library
License: MIT
Group: Sciences/Computer science
Url: https://ollama.com
Vcs: https://github.com/ollama/ollama-python

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3(hatch-vcs)
%{?!_without_check:%{?!_disable_check:
BuildRequires: pytest3
BuildRequires: python3(anyio)
BuildRequires: python3(httpx)
BuildRequires: python3(PIL)
BuildRequires: python3(pydantic)
BuildRequires: python3(pytest_asyncio)
BuildRequires: python3(pytest_httpserver)
}}

%description
The Ollama Python library.

%package -n python3-module-ollama
Summary: %summary
Group: Sciences/Computer science
BuildArch: noarch
Requires: python3(anyio)

%description -n python3-module-ollama
The Ollama Python library provides the easiest way to integrate Python 3.8+
projects with Ollama.

%package checkinstall
Summary: CI for %name
Group: Development/Other
Requires(post): python3-module-ollama = %EVR
Requires(post): python3
%ifarch aarch64 x86_64
Requires(post): ollama-cpu
%endif

%description checkinstall
%summary.

%prep
%setup
sed -Ei '/^version\s*=/s/"[0.]+"/"%version"/' pyproject.toml

%build
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest --ignore=examples

%post checkinstall
set -xe
%__python3 -c 'import ollama'
%__python3 -c 'import ollama; ollama.list()' |& grep 'ConnectionError'
type ollama || exit 0
ollama serve &
sleep 1
%__python3 -c 'import ollama; ollama.list(); ollama.ps()'
kill %%ollama
wait
rm -rf /root/.ollama

%files -n python3-module-ollama
%doc LICENSE *.md requirements.txt examples
%python3_sitelibdir_noarch/ollama
%python3_sitelibdir_noarch/ollama-%version.dist-info

%files checkinstall

%changelog
