%define _unpackaged_files_terminate_build 1

Name: onboard
Version: 1.4.2.2
Release: alt3

Summary: Simple on-screen Keyboard
License: GPL-3.0+ and BSD
Group: Graphical desktop/GNOME
URL: https://github.com/dr-ni/onboard
VCS: https://github.com/dr-ni/onboard

Source0: %name-%version.tar
Source1: ru.po
Patch: build-against-Ayatana-AppIndicator.patch
Patch1: 1004-fix-ftbfs-python3-12.patch
Patch2: fix-bool.patch

BuildRequires(pre): rpm-build-gnome rpm-macros-python3 rpm-build-pyproject
BuildRequires: gcc-c++
BuildRequires: desktop-file-utils
BuildRequires: intltool
BuildRequires: libXi-devel
BuildRequires: libXtst-devel
BuildRequires: libxkbcommon-devel
BuildRequires: libcanberra-devel
BuildRequires: libdconf-devel
BuildRequires: libgtk+3-devel
BuildRequires: libhunspell-devel
BuildRequires: libxkbfile-devel
BuildRequires: python3-module-distutils-extra >= 2.12
BuildRequires: libudev-devel
BuildRequires: python3(packaging)
BuildRequires: python3(wheel)

Requires: python3-module-dbus
# see ALT bug #35174
Requires: iso-codes
# see ALT bug #53881
Requires: python3-module-pygobject3

%add_python3_self_prov_path %buildroot%python3_sitelibdir/Onboard/pypredict

%description
An on-screen keyboard useful on tablet PCs or for mobility impaired
users.

%package gnome
Group:    Graphical desktop/GNOME
Summary:  GNOME Shell support for onboard
Requires: onboard = %version-%release
Requires: gnome-shell

%description gnome
GNOME Shell support for onboard.

%prep
%setup -q
%autopatch -p1
install -Dpm0644 %SOURCE1 po/ru.po
rm settings_ui.py

%build
export FAKEROOTKEY=1
%pyproject_build

%install
%pyproject_install

mv %buildroot%python3_sitelibdir/etc %buildroot

desktop-file-install --dir %buildroot%_desktopdir       \
    --remove-category="Accessibility"        \
    build/share/applications/%name.desktop
desktop-file-install --dir %buildroot%_desktopdir       \
    --remove-category="Accessibility"        \
    build/share/applications/%name-settings.desktop

mkdir -p %buildroot%_datadir/locale
cp -a build/mo/* %buildroot%_datadir/locale

# remove themed icons
rm -rf %buildroot%_iconsdir/ubuntu-mono-*

rm -rf %buildroot%_defaultdocdir/%name

%find_lang %name

%files -f %name.lang
%doc AUTHORS README.md HACKING *.example
%_bindir/%name
%_bindir/%name-settings
%_datadir/%name/
%_datadir/glib-2.0/schemas/*.gschema.xml
%_sysconfdir/xdg/autostart/%name-autostart.desktop
%_desktopdir/%name.desktop
%_desktopdir/%name-settings.desktop
%_man1dir/%{name}*.1*
%_iconsdir/HighContrast/symbolic/apps/onboard.svg
%_iconsdir/hicolor/scalable/apps/onboard-symbolic.svg
%_iconsdir/hicolor/scalable/apps/onboard.svg
%_iconsdir/hicolor/*x*/apps/onboard.png
%_datadir/sounds/freedesktop/stereo/onboard-key-feedback.oga
%_datadir/dbus-1/services/*
%python3_sitelibdir/Onboard/
%python3_sitelibdir/%name-*.dist-info
%_datadir/help/C/%name

%files gnome
%_datadir/gnome-shell/extensions/Onboard_Indicator@onboard.org

%changelog
