Name: opam
Version: 2.3.0
Release: alt2
Summary: A source-based package manager for OCaml
License: LGPLv3
Group: Development/ML
Url: https://github.com/ocaml/opam
Source0: %name-%version.tar
Patch0: %name-%version-alt.patch
BuildRequires: ocaml
BuildRequires: libacl-devel
BuildRequires: dune
BuildRequires: ocaml-opam-file-format-devel
BuildRequires: ocaml-cppo_ocamlbuild-devel
BuildRequires: ocaml-cppo
BuildRequires: ocaml-mccs-devel
BuildRequires: ocaml-findlib-devel
BuildRequires: ocaml-uutf-devel
BuildRequires: ocaml-ocamldoc
BuildRequires: ocaml-cudf-devel
BuildRequires: ocaml-ocamlgraph-devel
BuildRequires: ocaml-cmdliner-devel
BuildRequires: ocaml-re-devel
BuildRequires: ocaml-dose3-devel
BuildRequires: ocaml-extlib-devel
BuildRequires: ocaml-jsonm-devel
BuildRequires: ocaml-result-devel
BuildRequires: ocaml-spdx_licenses-devel
BuildRequires: ocaml-sha-devel
BuildRequires: ocaml-opam-0install-cudf-devel
BuildRequires: ocaml-swhid_core-devel
BuildRequires: curl gcc-c++

%description
OPAM stands for OCaml PAckage Manager.
It aims to suit to a vast number of users and use cases,
and has unique features:

 * Powerful handling of dependencies:
   versions constraints, optional dependencies, conflicts, etc.
 * Multiple repositories backends: HTTP, rsync, git
 * Ease to create packages and repositories
 * Ability to switch between different compiler versions

Typically, OPAM will probably make your life easier if you recognize
yourself in at least one of these profiles:

 * You use multiple versions of the OCaml compiler, or you hack the
   compiler yourself and needs to frequently switch between compiler
   versions.
 * You use or develop software that needs a specific and/or modified
   version of the OCaml compiler to be installed.
 * You use or develop software that depends on a specific version of an
   OCaml library, or you just want to install a specific version of a
   package, not just the latest one.
 * You want to create your own packages yourself, put them on your own
   repository, with minimal effort.

%package doc
Summary: Documentation files for %name
Group: Documentation
Requires: %name = %version-%release

%description doc
The %name-doc package contains documentation for using %name.

%prep
%setup -q
%patch0 -p1

%build
%configure
export DUNE_ARGS="--verbose"
export PATH=$PWD:$PATH

make

%install
export DUNE_ARGS="--verbose"
export PATH=$PWD:$PATH

%makeinstall_std LIBINSTALL_DIR=%buildroot%_libdir/ocaml

rm -rf %buildroot%prefix/doc

%files
%doc README.md LICENSE CHANGES
%doc AUTHORS CONTRIBUTING.md
%_bindir/%name
%_bindir/%name-installer
%_mandir/man1/%name.1*
%_mandir/man1/%name-*.1*

%files doc
%doc doc/
%doc tests/
%doc shell/

%changelog
