# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

%def_with doc

Name:     openFPGALoader
Version:  0.13.1
Release:  alt1

Summary:  Universal utility for programming FPGA
License:  Apache-2.0
Group:    Engineering
Url:      https://github.com/trabucayre/openFPGALoader

Source:   %name-%version.tar
# ALT patches
Patch:    0001-doc-Makefile-fix-build-with-python3-module-sphinx.patch

ExcludeArch: %arm

BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake
BuildRequires: gcc-c++
BuildRequires: libftdi1-devel
BuildRequires: libhidapi-devel
BuildRequires: zlib-ng-devel
BuildRequires: libudev-devel
BuildRequires: libgpiod-devel
BuildRequires: libusb-devel
%if_with doc
BuildRequires: python3-module-sphinx
BuildRequires: python3-module-yaml
BuildRequires: python3-module-tabulate
%endif

%description
%summary.

%package doc
Summary: Documentation for %name
Group:   Documentation

%description doc
%summary.

%prep
%setup
%autopatch -p1

# fix unavailable GROUP "plugdev"
sed -i 's/GROUP="plugdev"/GROUP="uucp"/g' 99-openfpgaloader.rules

%build
# fix build with gcc12
%add_optflags -Wno-narrowing

%cmake
%cmake_build
%if_with doc
%make_build -C doc/ man html
%endif

%install
%cmake_install

# install udev rules
mkdir -p %buildroot/lib/udev/rules.d/
install -pm644 99-openfpgaloader.rules %buildroot/lib/udev/rules.d/

# install man
mkdir -p %buildroot%_man1dir
install -pm644 doc/_build/man/openFPGALoader.1 %buildroot%_man1dir

%files
%_bindir/%name
/lib/udev/rules.d/99-openfpgaloader.rules
%_datadir/%name/
%doc README.md
%if_with doc
%_man1dir/openFPGALoader.1*
%endif

%if_with doc
%files doc
%doc doc/_build/html/*
%endif

%changelog
