%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%ifarch %ix86
%set_verify_elf_method relaxed
%else
%set_verify_elf_method strict
%endif

%def_without check

# TODO: build docs

%define soname 2.3

Name: opencolorio
Version: 2.3.0
Release: alt2.2

Summary: Enables color transforms and image display across graphics apps
License: BSD-3-Clause
Group: System/Libraries

URL: https://%name.org/

# https://github.com/imageworks/OpenColorIO.git
Source: OpenColorIO-%version.tar

Patch1: %name-alt-install.patch
Patch2: %name-alt-armh-multiple-definition.patch
Patch3: %name-yaml-cpp-0.8.patch
Patch4: %name-i586.patch

# Utilities
BuildRequires: cmake gcc-c++
BuildRequires: help2man

# WARNING: OpenColorIO and OpenImageIO are cross dependent.
# If an ABI incompatible update is done in one, the other also needs to be
# rebuilt.
BuildRequires: openexr-devel

# Libraries
BuildRequires: libGL-devel libGLU-devel
BuildRequires: libX11-devel libXmu-devel libXi-devel
BuildRequires: libfreeglut-devel
BuildRequires: libGLEW-devel
BuildRequires: zlib-devel
BuildRequires: libexpat-devel
BuildRequires: pystring-devel
BuildRequires: pybind11-devel
BuildRequires: python3-devel
BuildRequires: liblcms2-devel
BuildRequires: libyaml-cpp-devel
BuildRequires: boost-devel
BuildRequires: libimath29-devel
BuildRequires: python3-module-imath
BuildRequires: libminizip-ng-compat-devel

# Test dependencies
BuildRequires: ctest
BuildRequires: python3-module-numpy

%description
OCIO enables color transforms and image display to be handled in a consistent
manner across multiple graphics applications. Unlike other color management
solutions, OCIO is geared towards motion-picture post production, with an
emphasis on visual effects and animation color pipelines.

%package -n lib%name%soname
Summary: Enables color transforms and image display across graphics apps
Group: System/Libraries

%description -n lib%name%soname
OCIO enables color transforms and image display to be handled in a consistent
manner across multiple graphics applications. Unlike other color management
solutions, OCIO is geared towards motion-picture post production, with an
emphasis on visual effects and animation color pipelines.

%package tools
Summary: Command line tools for %name
Group: Other
Provides: opencolorio2.0-tools = %EVR
Provides: opencolorio2.2-tools = %EVR
Obsoletes: opencolorio2.0-tools < %EVR
Obsoletes: opencolorio2.2-tools < %EVR

%description tools
Command line tools for %name.

%package -n lib%name-devel
Summary: Development libraries and headers for %name
Group: Development/Other
Provides: libopencolorio2.0-devel = %EVR
Provides: libopencolorio2.2-devel = %EVR
Obsoletes: libopencolorio2.0-devel < %EVR
Obsoletes: libopencolorio2.2-devel < %EVR

%description -n lib%name-devel
Development libraries and headers for %name.

%package -n python3-module-%name
Summary: %name python3 module
Group: Development/Python3

%description -n python3-module-%name
%name python3 module.

%prep
%setup -n OpenColorIO-%version
%patch1 -p1
%patch2 -p1
%patch3 -p1
%ifarch %ix86
%patch4 -p1
%endif
%ifarch %e2k
# ld: multiple definition of LoadLutFile
sed -i "s/OCIO::LocalCachedFileRcPtr LoadLutFile/static &/" \
	tests/cpu/fileformats/*_tests.cpp
%endif

%build
%add_optflags -D_FILE_OFFSET_BITS=64

# disable debugging wrappers
%add_optflags -DNDEBUG

%cmake \
	-DCMAKE_BUILD_TYPE=RelWithDebInfo \
	-DBUILD_SHARED_LIBS:BOOL=ON \
	-DOCIO_BUILD_PYTHON:BOOL=ON \
	-DOCIO_BUILD_STATIC=OFF \
	-DOCIO_BUILD_DOCS=OFF \
	-DOCIO_BUILD_TESTS=ON \
	-DOCIO_BUILD_GPU_TESTS=OFF \
	-DOCIO_WARNING_AS_ERROR:BOOL=OFF \
%ifnarch x86_64 %e2k
	-DOCIO_USE_SSE=OFF \
%endif
%ifnarch %e2k
	-DOCIO_USE_GLVND:BOOL=ON \
	-DOpenGL_GL_PREFERENCE=GLVND \
%endif
	-DCMAKE_CXX_STANDARD=14 \
	-Dminizip-ng_INCLUDE_DIR=%_includedir/minizip \
	-DPYTHON_VARIANT_PATH=%python3_sitelibdir \
	%nil

%cmake_build

%install
%cmake_install

# Generate man pages
mkdir -p %buildroot%_man1dir

for i in %buildroot%_bindir/* ; do
	if [ "$(basename $i)" != "ociodisplay" ] ; then
		LD_LIBRARY_PATH=%buildroot%_libdir \
		help2man -N -s 1 --version-string=%version \
		-o %buildroot%_man1dir/$(basename $i).1 \
		$i
	fi
done
rm -fr %buildroot%_libdir/libOpenColorIOimageioapphelpers.a


%check
pushd %_cmake__builddir
# currently tests only pass on x86_64
# on other architectures there are precision issues
%ifarch x86_64
ctest
%else
ctest ||:
%endif
popd

%files -n lib%name%soname
%doc LICENSE THIRD-PARTY.md
%doc CHANGELOG.md CONTRIBUTING.md COMMITTERS.md GOVERNANCE.md PROCESS.md README.md SECURITY.md
%_libdir/*.so.%soname
%_libdir/*.so.%soname.*

%files tools
%_bindir/ocioarchive
%_bindir/ociobakelut
%_bindir/ociocheck
%_bindir/ociochecklut
%_bindir/ocioconvert
%_bindir/ociodisplay
%_bindir/ociolutimage
%_bindir/ociomakeclf
%_bindir/ocioperf
%_bindir/ociowrite
%_man1dir/*

%files -n lib%name-devel
%_includedir/OpenColorIO/
%_libdir/*.so
%_pkgconfigdir/*.pc
%_libdir/cmake/OpenColorIO/

%files -n python3-module-%name
%python3_sitelibdir/PyOpenColorIO

%changelog
