%define _unpackaged_files_terminate_build 1

# enable LTO/full debuginfo only on verified arches due resource constrains
%ifnarch x86_64 ppc64le aarch64
%define optflags_debug -g1
%global optflags_lto %nil
%define build_type Release
%else
%define build_type RelWithDebInfo
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict
%endif

%ifarch x86_64
%def_with cuda
%else
%def_without cuda
%endif

%define soname 10.1

Name: openvdb
Version: 10.1.0
Release: alt3.1
Summary: C++ library for sparse volumetric data discretized on three-dimensional grids
Group: Graphics
License: MPL-2.0-no-copyleft-exception
URL: https://www.openvdb.org

# https://github.com/AcademySoftwareFoundation/openvdb
Source: %name-%version.tar

Patch1: openvdb-8.0.0-alt-link-with-libatomic-on-mips.patch
Patch2: openvdb-10.1.0-add-missing-header.patch


BuildRequires(pre): rpm-build-python3
BuildRequires: boost-devel boost-interprocess-devel
BuildRequires: cmake
BuildRequires: doxygen
BuildRequires: gcc-c++
BuildRequires: ghostscript
BuildRequires: pkgconfig(blosc) >= 1.5.0
BuildRequires: pkgconfig(cppunit) >= 1.10
BuildRequires: pkgconfig(glfw3) >= 2.7
BuildRequires: imath-devel
BuildRequires: pkgconfig(jemalloc)
BuildRequires: pkgconfig(log4cplus) >= 1.0
BuildRequires: tbb-devel
BuildRequires: pkgconfig(xi)
BuildRequires: pkgconfig(zlib) > 1.2.7
BuildRequires: pkgconfig(python3)
BuildRequires: python3-module-numpy libnumpy-py3-devel
BuildRequires: pybind11-devel
%if_with cuda
BuildRequires: nvidia-cuda-devel-static
%endif

%description
OpenVDB is an Academy Award-winning open-source C++ library comprising a novel
hierarchical data structure and a suite of tools for the efficient storage and
manipulation of sparse volumetric data discretized on three-dimensional grids.
It is developed and maintained by Academy Software Foundation for use in
volumetric applications typically encountered in feature film production.

This package contains some graphical tools.

%package -n lib%name%soname
Summary: Core OpenVDB libraries
Group: System/Libraries

%description -n lib%name%soname
OpenVDB is an Academy Award-winning open-source C++ library comprising a novel
hierarchical data structure and a suite of tools for the efficient storage and
manipulation of sparse volumetric data discretized on three-dimensional grids.
It is developed and maintained by Academy Software Foundation for use in
volumetric applications typically encountered in feature film production.

%package devel
Summary: Development files for %{name}
Group: Development/C++
Requires: lib%name%soname = %EVR

%description devel
The %{name}-devel package contains libraries and header files for developing
applications that use %{name}.

%package -n python3-module-%name
Summary: OpenVDB Python module
Group: Development/Python3
Requires: lib%name%soname = %EVR

%description -n python3-module-%name
OpenVDB is an Academy Award-winning open-source C++ library comprising a novel
hierarchical data structure and a suite of tools for the efficient storage and
manipulation of sparse volumetric data discretized on three-dimensional grids.
It is developed and maintained by Academy Software Foundation for use in
volumetric applications typically encountered in feature film production.

This package contains the Python module.

%package doc
Summary: OpenVDB development documentation
Group: Documentation
Requires: %name-devel = %EVR
BuildArch: noarch

%description doc
OpenVDB development documentation

%prep
%setup
%autopatch -p1

# Hardcoded values
sed -i \
	-e 's|lib$|%_lib|g' \
	%name/%name/CMakeLists.txt %name/%name/python/CMakeLists.txt

%ifarch %e2k
# (10.1.0) lcc is not really gcc (still 1.26.21 pretends to be like 9.3.0)
sed -i 's,MINIMUM_GCC_VERSION 9.3.1,MINIMUM_GCC_VERSION 9.3.0,' \
	cmake/config/OpenVDBVersions.cmake
%endif

%build
%cmake \
	-DOPENVDB_BUILD_DOCS=ON \
	-DOPENVDB_CORE_SHARED=ON \
	-DOPENVDB_CORE_STATIC=OFF \
	-DOPENVDB_ENABLE_RPATH=OFF \
	-DOPENVDB_ENABLE_UNINSTALL:BOOL=OFF \
	-DUSE_IMATH_HALF=ON \
	-DUSE_LOG4CPLUS=ON \
	-DOPENVDB_BUILD_PYTHON_MODULE=ON \
	-DUSE_NUMPY:BOOL=ON \
	-DPYOPENVDB_INSTALL_DIRECTORY=%python3_sitelibdir \
	-DPython_EXECUTABLE=%_bindir/python3 \
	-DOPENVDB_USE_IMATH_HALF:BOOL=ON \
	-DOPENVDB_IMATH_VERSION=3 \
	-DOPENVDB_BUILD_NANOVDB:BOOL=ON \
	-DCMAKE_BUILD_TYPE=%build_type \
%ifarch x86_64
	-DOPENVDB_SIMD=SSE42 \
%endif
%if_with cuda
	-DNANOVDB_USE_CUDA=ON \
	-DNANOVDB_CUDA_KEEP_PTX=ON \
	-DNANOVDB_USE_INTRINSICS=ON \
%endif
	%nil

%cmake_build

%install
%cmakeinstall_std

%files
%_bindir/vdb_print
%_bindir/nanovdb_print
%_bindir/nanovdb_validate

%files -n lib%name%soname
%doc %name/%name/LICENSE %name/%name/COPYRIGHT
%doc README.md CHANGES
%_libdir/lib%{name}.so.%{soname}
%_libdir/lib%{name}.so.%{soname}.*

%files -n python3-module-%name
%python3_sitelibdir/py%{name}.cpython-*.so

%files devel
%_includedir/*
%_libdir/lib%{name}.so
%_libdir/cmake/*

%files doc
%_defaultdocdir/OpenVDB

%changelog
