%define _unpackaged_files_terminate_build 1
%def_enable proj

Name: osm2pgsql
Summary: Imports map data from www.OpenStreetMap.org to a PostgresSQL database
Group: Databases
Version: 1.7.1
Release: alt1

License: GPLv2+
Url: https://github.com/openstreetmap/osm2pgsql

Source: %name-%version.tar
Patch1: fix-install-osm2pgsql-replication.patch
BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake >= 3.5.0
BuildRequires: rpm-build-python3
BuildRequires: gcc-c++
BuildRequires: boost-devel boost-filesystem-devel boost-geometry-devel
BuildRequires: libexpat-devel
BuildRequires: libgeos-devel
BuildRequires: liblua5.3-devel
BuildRequires: libxml2-devel
BuildRequires: postgresql-devel >= 9.5
BuildRequires: bzlib-devel zlib-devel liblz4-devel
%{?_enable_proj:BuildRequires: libproj-devel}
BuildRequires: libprotobuf-c-devel
# TODO: external system libs
#BuildRequires: libfmt-devel libosmium-devel libprotozero-devel rapidjson-devel

%description
Processes the planet file from the communtiy mapping project at
http://www.openstreetmap.org. The map data is converted from XML to a
database stored in PostgreSQL with PostGIS geospatial extentions. This
database may then be used to render maps with Mapnik or for other
geospatial analysis.

%prep
%setup
%patch1 -p1

%build
%cmake
%cmake_build

%install
%cmakeinstall_std

%files
%doc docs README.md AUTHORS COPYING
%_bindir/%name
%_bindir/%name-replication
%_datadir/%name
%_man1dir/%name.*
%_man1dir/%name-replication.*

%changelog
