# vim: set ft=spec: -*- rpm -spec -*-

%define _unpackaged_files_terminate_build 1

# Fix build on older branches:
%if "%_pam_modules_dir" == "/%_lib/security"
    %global _libdir /%_lib
%endif

Name: pam_pkcs11
Version: 0.6.13.1
Release: alt1

Summary: PKCS #11 PAM Module and Login Tools
Group: System/Base
License: LGPL
Url: https://github.com/OpenSC/pam_pkcs11

Source: %name-%version.tar

Patch0: %name-0.6.13-confdir.patch
Patch1: %name-0.6.13-gost.patch
Patch2: %name-0.6.13-query-config.patch
Patch4: %name-0.6.13-scconf.patch
Patch6: %name-0.6.13-altconf.patch
Patch7: no-changelog-git.patch
Patch8: kde-smartcard-screensaver.patch

Requires: pam-config PAM(pam_mkhomedir.so) PAM(pam_pkcs11.so) PAM(pam_succeed_if.so)
Requires: pcsc-lite pcsc-lite-ccid

BuildRequires: docbook-style-xsl flex libldap-devel libpam-devel libpcsclite-devel libssl-devel xsltproc
BuildRequires: doxygen
BuildRequires: docbook-dtds

BuildRequires: libopensc-devel

BuildPreReq: gcc-c++
# SCARD_READERSTATE_A will change to SCARD_READERSTATE afterwards:
BuildPreReq: libpcsclite-devel >= 1.7.4

BuildRequires: libpasswdqc-devel

%description
This Linux-PAM login module allows a X.509 certificate based user login.
The certificate and its dedicated private key are thereby accessed by
means of an appropriate PKCS #11 module. For the verification of the
user certificates, locally stored CA certificates as well as either
online or locally accessible CRLs are used.

Adittional included pam_pkcs11 related tools:

 - pkcs11_eventmgr: Generate actions on card insert/removal/timeout
   events
 - pklogin_finder: Get the loginname that maps to a certificate
 - pkcs11_inspect: Inspect the contents of a certificate

%package pcsc
Summary: PCSC-Lite extra tools for pam_pkcs11
Group: System/Base
Requires: %name = %version-%release

%description pcsc
This package contains pam_pkcs11 tools that relies on PCSC-Lite library:

 - card_eventmgr: Generate card insert/removal events.

%package ldap
Summary: LDAP Cert-to-Login mapper for pam_pkcs11
Group: System/Base
Requires: %name = %version-%release

%description ldap
This package contains a Certificate-To-Login mapper based on queries
to a LDAP server. As it depends on extra libraries, is distributed
as a separate package.

- ldap_mapper.so: LDAP-based mapper module.

%prep
%setup
%autopatch -p1

# fixup configs
sed -i -e '
	s,/usr/lib/pam_pkcs11/,%_libdir/%name/,g;
	s,/usr/lib/,%_libdir/,g;
	s,/etc/pam_pkcs11/,%_sysconfdir/security/%name/,g;
	' etc/*.example doc/*.in doc/*.xml

%build
%autoreconf
#	--disable-rpath \
%configure \
	--libdir=%_libdir \
	--disable-static \
	--enable-shared \
	--enable-debug \
	--with-ldap \
	--with-confdir=%_sysconfdir/security/%name \
    --with-passwdqc \
	#
%make_build docdir=%_datadir/doc/%name-%version
cd doc
./generate-api.sh

%install
%makeinstall_std docdir=%_datadir/doc/%name-%version unitdir=%_unitdir

mkdir -p %buildroot%_sysconfdir/security/%name/{cacerts,crls}

# Install the example configs in /etc
install -D -m0644 \
        %buildroot%_datadir/doc/%name-%version/pam_pkcs11.conf.example \
        %buildroot%_sysconfdir/security/%name/pam_pkcs11.conf
install -D -m0644 \
        %buildroot%_datadir/doc/%name-%version/pkcs11_eventmgr.conf.example \
        %buildroot%_sysconfdir/security/%name/pkcs11_eventmgr.conf
install -D -m0644 \
        %buildroot%_datadir/doc/%name-%version/card_eventmgr.conf.example \
        %buildroot%_sysconfdir/security/%name/card_eventmgr.conf

install -D -m0644 \
        %buildroot%_datadir/doc/%name-%version/digest_mapping.example \
        %buildroot%_sysconfdir/security/%name/digest_mapping
install -D -m0644 \
        %buildroot%_datadir/doc/%name-%version/mail_mapping.example \
        %buildroot%_sysconfdir/security/%name/mail_mapping
install -D -m0644 \
        %buildroot%_datadir/doc/%name-%version/subject_mapping.example \
        %buildroot%_sysconfdir/security/%name/subject_mapping

# Cleanup .la files
rm %buildroot%_libdir/*/*.la

%find_lang %name

%check
# This is not really a test-suite check. However, run
# distcheck, following the CI workflow in upstream.
%make_build distcheck

%post
[ ! -e %_sysconfdir/security/%name/openssl.cnf ] || \
    mv -v %_sysconfdir/security/%name/openssl.cnf \
          %_sysconfdir/security/%name/openssl.cnf.rpmold

%files -f %name.lang
%dir %_sysconfdir/security/%name
%dir %_sysconfdir/security/%name/cacerts
%dir %_sysconfdir/security/%name/crls
%config(noreplace) %_sysconfdir/security/%name/pam_pkcs11.conf
%config(noreplace) %_sysconfdir/security/%name/pkcs11_eventmgr.conf
%config(noreplace) %_sysconfdir/security/%name/*_mapping
%_bindir/*
%exclude %_bindir/card_eventmgr
%dir %_libdir/%name
%_libdir/%name/openssh_mapper.so
%_libdir/%name/opensc_mapper.so
%_pam_modules_dir/pam_pkcs11.so
%_man1dir/*.1*
%exclude %_man1dir/card_eventmgr.1*
%_man8dir/*.8*
%_unitdir/*
%_datadir/doc/%name-%version/*.example

%files pcsc
%config(noreplace) %_sysconfdir/security/%name/card_eventmgr.conf
%_bindir/card_eventmgr
%_man1dir/card_eventmgr.1*

%files ldap
%_libdir/%name/ldap_mapper.so

%changelog
