%def_disable snapshot
%def_enable check

%define _libexecdir %_prefix/libexec

%define ver_major 7.1
%define _name files
%define xdg_name org.pantheon.%_name
%define rdn_name io.elementary.%_name

Name: pantheon-files
Version: %ver_major.0
Release: alt1

Summary: The file manager of the Pantheon desktop
License: GPL-3.0
Group: File tools
Url: https://github.com/elementary/%_name

%if_disabled snapshot
Source: %url/archive/%version/%_name-%version.tar.gz
%else
Vcs: https://github.com/elementary/files.git
Source: %_name-%version.tar
%endif

Provides: %rdn_name = %EVR

#Depends: tumbler
#Recommends: contractor
#Suggests: tumbler-plugins-extra
Requires: polkit zeitgeist tumbler elementary-icon-theme

%define vala_ver 0.48.2
%define glib_ver 2.64.6
%define gtk_ver 3.22.25
%define granite_ver 6.1.0

BuildRequires(pre): rpm-macros-meson rpm-build-systemd
BuildRequires: meson vala-tools > %vala_ver
BuildRequires: libgio-devel >= %glib_ver
BuildRequires: libappstream-glib-devel desktop-file-utils
BuildRequires: libsqlite3-devel libgtk+3-devel >= %gtk_ver
BuildRequires: libgee0.8-devel libgranite-devel
BuildRequires: libdbus-glib-devel libnotify-devel
BuildRequires: libxkbcommon-devel libgranite-vala >= %granite_ver
BuildRequires: libzeitgeist2.0-devel libplank-devel libplank-vala
BuildRequires: libpolkit-devel
BuildRequires: libcanberra-devel libcanberra-vala
BuildRequires: libcloudproviders-devel
BuildRequires: libgit2-glib-devel
BuildRequires: pkgconfig(libhandy-1)
BuildRequires: pkgconfig(libportal)
BuildRequires: pkgconfig(libportal-gtk3)
%{?_enable_check:BuildRequires: elementary-icon-theme}

%description
The simple, powerful, and sexy file manager from elementary.

%package devel
Summary: Development files for pantheon-files
Group: Development/C
Requires: %name = %EVR

%description devel
Development files for pantheon-files.

%package vala
Summary: Vala language bindings for the pantheon-files
Group: Development/Other
BuildArch: noarch
Requires: %name-devel = %EVR

%description vala
This package provides Vala language bindings for the pantheon-files.

%prep
%setup -n %_name-%version

%build
%meson
%meson_build

%install
%meson_install
%find_lang %rdn_name

%check
%__meson_test

%files -f %rdn_name.lang
%doc AUTHORS README*
%_bindir/*
%_libdir/*.so.*
%_libdir/%rdn_name/
%_desktopdir/%rdn_name.desktop
%_datadir/dbus-1/services/%rdn_name.service
%_datadir/dbus-1/services/%rdn_name.Filemanager1.service
%_datadir/glib-2.0/schemas/%rdn_name.gschema.xml
%_datadir/polkit-1/actions/%rdn_name.policy
%_datadir/metainfo/%rdn_name.metainfo.xml

%_libexecdir/%rdn_name.xdg-desktop-portal
%_prefix/lib/systemd/user/%rdn_name.xdg-desktop-portal.service
%_datadir/dbus-1/services/org.freedesktop.impl.portal.desktop.elementary.files.service
%_datadir/xdg-desktop-portal/portals/%rdn_name.portal

%files devel
%_includedir/%name-core/
%_libdir/*.so
%_pkgconfigdir/%name-core.pc

%if 0
%files vala
%_vapidir/%name-core.vapi
%endif

%changelog
