Name: parole
Version: 4.20.0
Release: alt1

%if_xfce4_wayland_support
%def_enable wayland
%else
%def_disable wayland
%endif
%def_disable docs

Summary: Media player for the Xfce desktop
License: GPLv2+
Group: Video

URL: https://docs.xfce.org/apps/parole/start
Vcs: https://gitlab.xfce.org/apps/parole.git
Source: %name-%version.tar
Patch: %name-%version-%release.patch
Packager: Xfce Team <xfce@packages.altlinux.org>

BuildRequires(pre): meson rpm-macros-meson >= 1.3.1-alt1
BuildRequires(pre): rpm-build-xfce4 >= 0.3.0 xfce4-dev-tools
BuildRequires: libxfce4ui-gtk3-devel libxfce4util-devel libxfconf-devel
BuildRequires: libgtk+3-devel libnotify-devel taglib-devel
BuildRequires: gstreamer1.0-devel gst-plugins1.0-devel
BuildRequires: libdbus-glib-devel libdbus-devel
%{?_enable_docs:BuildRequires: BuildRequires: gtk-doc}

Requires: gstreamer1.0
Requires: gst-plugins-base1.0 gst-plugins-good1.0 gst-plugins-bad1.0 gst-plugins-ugly1.0 gst-libav
Requires: xfconf-utils

%define _unpackaged_files_terminate_build 1

%description
Parole is a modern simple media player based on the GStreamer framework
and written to fit well in the Xfce desktop. Parole features playback of
local media files, DVD/CD and live streams. Parole is extensible via
plugins.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: libgtk+3-devel
BuildArch: noarch

%description devel
This package contains header files and documentation
for developing plugins for %name.

%prep
%setup
%patch -p1

%build
%meson \
	-Dx11=enabled \
	%{subst_enable_meson_feature wayland wayland} \
	-Dtaglib=enabled \
	%{subst_enable_meson_bool docs gtk-doc}

%meson_build -v

%install
%meson_install
%find_lang %name

%files -f %name.lang
%doc AUTHORS README.md THANKS NEWS
%_bindir/%name
%_libdir/%name-*/
%_desktopdir/*.desktop
%_datadir/metainfo/%name.appdata.xml
%_iconsdir/hicolor/*/apps/*
%_datadir/%name/

%files devel
%_includedir/*
%if_enabled docs
%doc %_datadir/gtk-doc/html/*
%endif

%changelog
