Name:           pdfmod
Version:        0.9.1
Release:        alt10

Summary:        PDF Modifier
License:        GPL-2.0+
Group:          File tools

Url:            https://wiki.gnome.org/Apps/PdfMod
Source0:        %name-%version.tar.gz
Patch0:         pdfmod-0.9.1-alt-fix-configure.patch
Packager:       Korneechev Evgeniy <ekorneechev@altlinux.org>

BuildRequires:  /proc
BuildRequires:  gnome-doc-utils
BuildRequires:  hyena-devel
BuildRequires:  intltool
BuildRequires:  libgnome-sharp-devel
BuildRequires:  mono-data
BuildRequires:  mono-devel
BuildRequires:  python3-base

Requires:       gawk
Requires:       libgnome-sharp
Requires:       libgtk-sharp2
Requires:       libpoppler8-glib
Requires:       mono-core >= 5.0

%description
PDF Mod is a simple tool for modifying your PDFs: moving, removing,
extracting, and rotating pages.

%prep
%setup
%patch0 -p1

%build
%configure
%make_build

%install
%make_install install DESTDIR=%buildroot
%find_lang %name %{?no_lang_C}

%post
awk '{gsub ("</configuration>", "", $0); print > FILENAME}' %_sysconfdir/mono/config
echo '  <dllmap dll="glib-2.0.dll" target="libglib-2.0.so.0" os="!windows"/>' >> %_sysconfdir/mono/config
echo "</configuration>" >> %_sysconfdir/mono/config

%files -f %name.lang
%doc AUTHORS NEWS README COPYING
%_datadir/gnome/help/%name/
%_bindir/%name
%_libdir/%name/
%_datadir/icons/hicolor/*/apps/*
%_datadir/applications/%name.desktop

%changelog
