%define _unpackaged_files_terminate_build 1
#
#   - Exception::Class::TryCatch -
#   This spec file was automatically generated by cpan2rpm [ver: 2.027]
#   (ALT Linux revision)
#   The following arguments were used:
#       --debug --version 1.10 Exception::Class::TryCatch
#   For more information on cpan2rpm please visit: http://perl.arix.com/
#

%define module Exception-Class-TryCatch
%define m_distro Exception-Class-TryCatch
%define m_name Exception::Class::TryCatch
%define m_author_id unknown
%define _enable_test 1

Name: perl-Exception-Class-TryCatch
Version: 1.13
Release: alt1

Summary: %m_name - Syntactic try/catch sugar for use with Exception::Class

License: Artistic
Group: Development/Perl
Url: http://search.cpan.org/dist/Exception-Class-TryCatch/

Packager: Michael Bochkaryov <misha@altlinux.ru>

BuildArch: noarch
Source: http://www.cpan.org/authors/id/D/DA/DAGOLDEN/Exception-Class-TryCatch-%{version}.tar.gz

# Automatically added by buildreq on Tue Jul 29 2008 (-bi)
BuildRequires: perl-Exception-Class perl-Module-Build perl-version

%description
Exception::Class::TryCatch provides syntactic sugar for use with
Exception::Class using the familiar keywords try and catch. Its primary
objective is to allow users to avoid dealing directly with $@ by ensuring that
any exceptions caught in an eval are captured as Exception::Class objects,
whether they were thrown objects to begin with or whether the error resulted
from die. This means that users may immediately use isa and various
Exception::Class methods to process the exception.

In addition, this module provides for a method to push errors onto a hidden
error stack immediately after an eval so that cleanup code or other error
handling may also call eval without the original error in $@ being lost.

Inspiration for this module is due in part to Dave Rolsky's article "Exception
Handling in Perl With Exception::Class" in The Perl Journal (Rolsky 2004).

The try/catch syntax used in this module does not use code reference prototypes
the way the Error.pm module does, but simply provides some helpful
functionality when used in combination with eval. As a result, it avoids the
complexity and dangers involving nested closures and memory leaks inherent in
Error.pm (Perrin 2003).

Rolsky (2004) notes that these memory leaks may not occur in recent versions of
Perl, but the approach used in Exception::Class::TryCatch should be safe for
all versions of Perl as it leaves all code execution to the eval in the current
scope, avoiding closures altogether.

%prep
%setup -q -n %m_distro-%version
%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%perl_vendor_privlib/*
%doc Changes LICENSE README
%exclude %perl_vendor_archlib

%changelog
