# BEGIN SourceDeps(oneline):
BuildRequires: perl(Cairo.pm) perl(Carp/Always.pm) perl(Glib.pm) perl(Glib/Object/Subclass.pm) perl(Gtk3.pm) perl(Image/Magick.pm) perl(Readonly.pm) perl(Test/Deep.pm) perl(Test/MockObject.pm) perl(Test/Perl/Critic.pm) perl(Try/Tiny.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
# we use xvfb-run
#def_without test
%define _without_test 1

Name: perl-Gtk3-ImageView
Version: 10
Release: alt2

Summary: Image viewer widget for GTK 3

License: Perl
Group: Development/Perl
Url: https://metacpan.org/release/Gtk3-ImageView

Packager: Vitaly Lipatov <lav@altlinux.ru>

Source0: http://www.cpan.org/authors/id/A/AS/ASOKOLOV/Gtk3-ImageView-%{version}.tar.gz

BuildArch: noarch

BuildRequires(pre): rpm-build-perl
BuildRequires: perl-devel

# Run-time:
BuildRequires: perl(Cairo.pm)
BuildRequires: perl(Carp/Always.pm)
BuildRequires: perl(Glib.pm)
BuildRequires: perl(Glib/Object/Subclass.pm)
BuildRequires: perl(Gtk3.pm)
BuildRequires: perl(Readonly.pm)

# Tests:
BuildRequires: perl(Image/Magick.pm)
BuildRequires: perl(Test/Deep.pm)
BuildRequires: perl(Test/MockObject.pm)
BuildRequires: perl(Test/Perl/Critic.pm)
BuildRequires: perl(Try/Tiny.pm)
BuildRequires: xvfb-run

# Optional tests:
# git-core not used
# Test::Perl::Critic not used
Requires: perl(if.pm)
Requires: perl(Glib.pm) >= 1.21

%description
The Gtk3::ImageView widget allows the user to zoom, pan and select the
specified image and provides hooks to allow additional tools, e.g. painter,
to be created and used.

%prep
%setup -q -n Gtk3-ImageView-%{version}
# Bareword "Gtk3::Gdk::Display::get_default" not allowed while "strict subs"
sed -i -e "3iuse Gtk3;" lib/Gtk3/ImageView/Tool.pm

%build
%perl_vendor_build
xvfb-run -a make test

%install
%perl_vendor_install


%files
%doc README.md Changes README
%perl_vendor_privlib/*

%changelog
