# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Pod/Coverage/TrustPod.pm) perl(Test/CPAN/Meta.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Proc-InvokeEditor
%define upstream_version 1.13

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_2

Summary:    Perl extension for starting a text editor
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        http://search.cpan.org/dist/%{upstream_name}
Source0:    http://www.cpan.org/modules/by-module/Proc/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Carp/Assert.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(File/Spec.pm)
BuildRequires: perl(File/Temp.pm)
BuildRequires: perl(IPC/Cmd.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: ed
BuildArch:  noarch
Source44: import.info

%description
This module provides the ability to supply some text to an external text
editor, have it edited by the user, and retrieve the results.

The File::Temp module is used to provide secure, safe temporary files, and
File::Temp is set to its highest available level of security. This may
cause problems on some systems where no secure temporary directory is
available.

When the editor is started, no subshell is used. Your path will be scanned
to find the binary to use for each editor if the string given does not
exist as a file, and if a named editor contains whitespace, eg) if you try
to use the editor 'xemacs -nw', then the string will be split on whitespace
and anything after the editor name will be passed as arguments to your
editor. A shell is not used but this should cover most simple cases.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLMAN1DIR=%_man1dir INSTALLDIRS=vendor

%make

%check
%make test

%install
%makeinstall_std

%files
%doc Changes LICENSE META.json META.yml  README examples
%perl_vendor_privlib/Proc/

%changelog
