#
#   - Schedule::At -
#   This spec file was automatically generated by cpan2rpm [ver: 2.027]
#   (ALT Linux revision)
#   The following arguments were used:
#       --spec-only Schedule-At-1.06.tar.gz --make-no-test
#   For more information on cpan2rpm please visit: http://perl.arix.com/
#

%define module Schedule-At
%define m_distro Schedule-At
%define m_name Schedule::At
%define m_author_id unknown
%define _disable_test 1

Name: perl-Schedule-At
Version: 1.15
Release: alt1

Summary: OS independent interface to the Unix 'at' command

License: Artistic
Group: Development/Perl
Url: http://www.cpan.org

Packager: Vladimir A. Svyatoshenko <svyt@altlinux.ru>

BuildArch: noarch
Source: http://www.cpan.org/authors/id/J/JO/JOSERODR/Schedule-At-%{version}.tar.gz

# Automatically added by buildreq on Fri Apr 18 2008
BuildRequires: perl-devel

%description
This modules provides an OS independent interface to 'at', the Unix
command that allows you to execute commands at a specified time.

=over 4

=item Schedule::At::add

Adds a new job to the at queue.

You have to specify a TIME and a command to execute. The TIME has
a common format: YYYYMMDDHHmm. Where YYYY is the year (4 digits), MM
the month (01-12), DD is the day (01-31), HH the hour (00-23) and
mm the minutes.

The command is passed with the COMMAND or the FILE parameter.
COMMAND can be used to pass the command as an string, and FILE to
read the commands from a file.

The optional parameter TAG serves as an application specific way to
identify a job or a set of jobs.

Returns 0 on success or a value != 0 if an error occurred.

=item Schedule::At::readJob

Read the job content identified by the JOBID or TAG parameters.

Returns an string with the job content. As the operating systems usually
add a few environment settings, the content is longer than the command
provided when adding the job.

=item Schedule::At::remove

Remove an at job.

You identify the job to be deleted using the JOBID parameter (an
opaque string returned by the getJobs subroutine). You can also specify
a job or a set of jobs to delete with the TAG parameter, removing
all the jobs that have the same tag (as specified with the add subroutine).

Returns 0 on success or a value != 0 if an error occurred.

=item Schedule::At::getJobs

Called with no params returns a hash with all the current jobs or
dies if an error has occurred.
It's possible to specify the TAG or JOBID parameters so only matching
jobs are returned.
For each job the key is a JOBID (an OS dependent string that shouldn't be
interpreted), and the value is a hash reference.

This hash reference points to a hash with the keys:

=over 4

=item TIME

An OS dependent string specifying the time to execute the command

=item TAG

The tag specified in the Schedule::At::add subroutine

=back

=back

%prep
%setup -q -n %m_distro-%version
%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%perl_vendor_privlib/Schedule*

%changelog
