%ifndef _unitdir_user
%define _unitdir_user %prefix/lib/systemd/user
%endif

%define rname libkscreen
Name: plasma5-%rname
Version: 5.27.11
Release: alt3
%K5init

Group: System/Libraries
Summary: KDE Workspace 5 display configuration library
Url: http://www.kde.org
License: GPL-2.0-or-later

Provides: kf5-libkscreen = %EVR
Obsoletes: kf5-libkscreen < %EVR

Source: %rname-%version.tar
Patch1: alt-pnp-ids-path.patch

# Automatically added by buildreq on Wed Feb 25 2015 (-bi)
# optimized out: cmake cmake-modules elfutils libEGL-devel libGL-devel libICE-devel libSM-devel libX11-devel libXScrnSaver-devel libXau-devel libXcomposite-devel libXcursor-devel libXdamage-devel libXdmcp-devel libXext-devel libXfixes-devel libXft-devel libXi-devel libXinerama-devel libXmu-devel libXpm-devel libXrandr-devel libXrender-devel libXt-devel libXtst-devel libXv-devel libXxf86misc-devel libXxf86vm-devel libcloog-isl4 libqt5-core libqt5-dbus libqt5-gui libqt5-test libqt5-x11extras libstdc++-devel libxcb-devel libxkbfile-devel pkg-config python-base qt5-base-devel ruby ruby-stdlibs xorg-kbproto-devel xorg-randrproto-devel xorg-renderproto-devel xorg-xf86miscproto-devel xorg-xproto-devel
#BuildRequires: extra-cmake-modules gcc-c++ python-module-google qt5-x11extras-devel rpm-build-ruby
BuildRequires(pre): rpm-build-kf5
BuildRequires: extra-cmake-modules
BuildRequires: qt5-x11extras-devel qt5-tools-devel
BuildRequires: qt5-wayland-devel kf5-kwayland-devel kde5-plasma-wayland-protocols
BuildRequires: kf5-kconfig-devel

%description
LibKScreen is a library that provides access to current configuration
of connected displays and ways to change the configuration.

%package common
Summary: %name common package
Group: System/Configuration/Other
BuildArch: noarch
Requires: kf5-filesystem
Provides: kf5-libkscreen-common = %EVR
Obsoletes: kf5-libkscreen-common < %EVR
%description common
%name common package

%package devel
Group: Development/KDE and QT
Summary: Development files for %name
Provides: kf5-libkscreen-devel = %EVR
Obsoletes: kf5-libkscreen-devel < %EVR
%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package -n libkf5screen
Group: System/Libraries
Summary: %name library
Requires: %name-common >= %EVR
Requires: hwdatabase
%description -n libkf5screen
%name library

%package -n libkf5screendpms
Group: System/Libraries
Summary: %name library
Requires: %name-common >= %EVR
%description -n libkf5screendpms
%name library

%package utils
Group: Graphical desktop/KDE
Summary: %name utils
Requires: %name-common >= %EVR
Provides: kf5-libkscreen-utils = %EVR
Obsoletes: kf5-libkscreen-utils < %EVR
%description utils
%name utils.

%prep
%setup -n %rname-%version
%patch1 -p1

%build
export PATH=%_qt5_bindir:$PATH
%K5build

%install
%K5install
%K5install_move data locale
%find_lang %name --all-name
%K5find_qtlang %name --append --all-name

%files common -f %name.lang
%doc LICENSES/*
%_datadir/qlogging-categories5/*.*categories

%files utils
%_K5bin/*
%_kf5_exec/kscreen_backend_launcher
%_K5plug/kf5/kscreen/
%_K5dbus_srv/org.kde.kscreen.service
%_unitdir_user/*.service
%_datadir/zsh/site-functions/_*

%files devel
%_K5inc/kscreen_version.h
%_K5inc/KScreen/
%_K5link/lib*.so
%_K5lib/cmake/KF5Screen
%_K5archdata/mkspecs/modules/qt_KScreen.pri
%_pkgconfigdir/*.pc

%files -n libkf5screen
%_K5lib/libKF5Screen.so.*

%files -n libkf5screendpms
%_K5lib/libKF5ScreenDpms.so.*

%changelog
