%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1

%define _libexecdir %prefix/libexec

# skip autogenerated dependency on selinux-policy-alt
%filter_from_requires /^\/etc\/selinux\/config$/d

Summary: SELinux policy core utilities
Name: policycoreutils
Epoch:   1
Version: 3.8
Release: alt1
License: GPLv2
Group: System/Base
Url: https://github.com/SELinuxProject/selinux

Source0: %name-%version.tar

Source1: restorecond.init
Source2: sandbox.init
Source3: system-config-selinux.pam
Source6: system-config-selinux.console
Source8: selinux-polgengui.console
Source9: mcstrans.init

Source13: selinux-python-%version.tar
Source14: selinux-gui-%version.tar
Source15: selinux-sandbox-%version.tar
Source16: selinux-dbus-%version.tar
Source17: semodule-utils-%version.tar
Source18: restorecond-%version.tar
Source19: mcstrans-%version.tar

Patch1: %name-%version-policycoreutils-alt.patch
Patch2: %name-%version-python-alt.patch
Patch6: %name-%version-restorecond-alt.patch
Patch7: %name-%version-mcstrans-alt.patch

%define mcstrans_ver 0.3.3
Requires: python3-module-semanage python3-module-audit

BuildRequires(pre): rpm-build-xdg
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-pyproject-installer
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: libaudit-devel libcap-devel libpam-devel
BuildRequires: libselinux-devel libsemanage-devel libsepol-devel libsepol-devel-static
BuildRequires: desktop-file-utils
BuildRequires: glib2-devel libgio-devel
BuildRequires: libcap-ng-devel libpcre2-devel libcgroup-devel
BuildRequires: libsystemd-devel

%add_python3_path %_datadir/system-config-selinux

%description
policycoreutils contains the policy core utilities that are required
for basic operation of a SELinux system.  These utilities include
load_policy to load policies, setfiles to label filesystems, newrole
to switch roles, and run_init to run /etc/init.d scripts in the proper
context.

%package newrole
Summary: The newrole application for RBAC/MLS
Group: System/Base
Requires: %name = %EVR

%description newrole
RBAC/MLS policy machines require newrole as a way of changing the role
or level of a logged in user.

%package sandbox
Summary: SELinux sandbox utilities
Group: System/Base
Requires: %name = %EVR

%description sandbox
This package contains the sandbox which allow you to run an applications
within a tightly confined SELinux domain.

%package sandbox-x
Summary: SELinux sandbox utilities for X applications
Group: System/Base
Requires: %name-sandbox = %EVR
Requires: xorg-xephyr
Requires: matchbox-window-manager
Requires: xmodmap
BuildArch: noarch

%description sandbox-x
This package contains the scripts to create graphical sandboxes.

%package restorecond
Summary: SELinux restorecond utilities
Group:   System/Base
Obsoletes: mcstrans <= 0.3.1
Provides: mcstrans = %mcstrans_ver

%description restorecond
This package contains the restorecond service.

%package mcstransd
Summary: SELinux Translation Daemon
Group: System/Base

%description mcstransd
mcstrans provides an translation daemon to translate SELinux categories
from internal representations to user defined representation.

%package devel
Requires: %name = %EVR
Summary: SELinux policy core policy devel utilities
Group: System/Base

%description devel
The policycoreutils-devel package contains the management tools use to
develop policy in an SELinux environment.

%package gui
Summary: SELinux configuration GUI
Group: System/Base
Requires: policycoreutils = %EVR

%description gui
system-config-selinux is a utility for managing the SELinux environment.

%package -n python3-module-policycoreutils
Summary: SELinux policy core python utilities
Group:   Development/Python3
Requires: %name = %EVR
Provides: policycoreutils-python-utils

%description -n python3-module-policycoreutils
The policycoreutils-python package contains the management tools use to manage
an SELinux environment.

%package -n python3-module-policycoreutils-gui
Summary: SELinux policy core python utilities
Group:   Development/Python3
Requires: python3-module-policycoreutils = %EVR

%description -n python3-module-policycoreutils-gui
The policycoreutils-python package contains the management tools use to manage
an SELinux environment.

%prep
%setup -c -n selinux
%setup -q -T -D -a 13 -n selinux
%setup -q -T -D -a 14 -n selinux
%setup -q -T -D -a 15 -n selinux
%setup -q -T -D -a 16 -n selinux
%setup -q -T -D -a 17 -n selinux
%setup -q -T -D -a 18 -n selinux
%setup -q -T -D -a 19 -n selinux

pushd %name-%version
%patch1 -p1
popd

pushd selinux-python-%version
%patch2 -p1
popd

pushd restorecond-%version
%patch6 -p1
popd

pushd mcstrans-%version
%patch7 -p1
popd

%build
%make_build -C policycoreutils-%version LSPP_PRIV=y SBINDIR="%_sbindir" LIBDIR="%_libdir" LIBEXECDIR="%_libexecdir" LIBSEPOLA="%_libdir/libsepol.a" CFLAGS="%optflags %optflags_shared" LDFLAGS="-pie -Wl,-z,relro" all
%make_build -C selinux-python-%version LSPP_PRIV=y SBINDIR="%_sbindir" LIBDIR="%_libdir" LIBEXECDIR="%_libexecdir" LIBSEPOLA="%_libdir/libsepol.a" CFLAGS="%optflags %optflags_shared" LDFLAGS="-pie -Wl,-z,relro" all
%make_build -C selinux-gui-%version LSPP_PRIV=y SBINDIR="%_sbindir" LIBDIR="%_libdir" LIBEXECDIR="%_libexecdir" LIBSEPOLA="%_libdir/libsepol.a" CFLAGS="%optflags %optflags_shared" LDFLAGS="-pie -Wl,-z,relro" all
%make_build -C selinux-sandbox-%version LSPP_PRIV=y SBINDIR="%_sbindir" LIBDIR="%_libdir" LIBEXECDIR="%_libexecdir" LIBSEPOLA="%_libdir/libsepol.a" CFLAGS="%optflags %optflags_shared" LDFLAGS="-pie -Wl,-z,relro" all
%make_build -C selinux-dbus-%version LSPP_PRIV=y SBINDIR="%_sbindir" LIBDIR="%_libdir" LIBEXECDIR="%_libexecdir" LIBSEPOLA="%_libdir/libsepol.a" CFLAGS="%optflags %optflags_shared" LDFLAGS="-pie -Wl,-z,relro" all
%make_build -C semodule-utils-%version LSPP_PRIV=y SBINDIR="%_sbindir" LIBDIR="%_libdir" LIBEXECDIR="%_libexecdir" LIBSEPOLA="%_libdir/libsepol.a" CFLAGS="%optflags %optflags_shared" LDFLAGS="-pie -Wl,-z,relro" all
%make_build -C restorecond-%version LSPP_PRIV=y SBINDIR="%_sbindir" LIBDIR="%_libdir" LIBEXECDIR="%_libexecdir" LIBSEPOLA="%_libdir/libsepol.a" CFLAGS="%optflags %optflags_shared" LDFLAGS="-pie -Wl,-z,relro" all
%make_build -C mcstrans-%version SBINDIR="%_sbindir" LIBDIR=%_libdir CFLAGS="%optflags $(pkg-config --cflags-only-I libpcre2)" LIBSEPOLA="%_libdir/libsepol.a"

%install
%makeinstall_std -C policycoreutils-%version LSPP_PRIV=y SBINDIR="%_sbindir" LIBDIR="%_libdir" LIBEXECDIR="%_libexecdir" LIBSEPOLA="%_libdir/libsepol.a" CFLAGS="%optflags %optflags_shared" LDFLAGS="-pie -Wl,-z,relro"
%makeinstall_std -C selinux-python-%version LSPP_PRIV=y SBINDIR="%_sbindir" LIBDIR="%_libdir" LIBEXECDIR="%_libexecdir" LIBSEPOLA="%_libdir/libsepol.a" CFLAGS="%optflags %optflags_shared" LDFLAGS="-pie -Wl,-z,relro"
%makeinstall_std -C selinux-gui-%version LSPP_PRIV=y SBINDIR="%_sbindir" LIBDIR="%_libdir" LIBEXECDIR="%_libexecdir" LIBSEPOLA="%_libdir/libsepol.a" CFLAGS="%optflags %optflags_shared" LDFLAGS="-pie -Wl,-z,relro"
%makeinstall_std -C selinux-sandbox-%version LSPP_PRIV=y SBINDIR="%_sbindir" LIBDIR="%_libdir" LIBEXECDIR="%_libexecdir" LIBSEPOLA="%_libdir/libsepol.a" CFLAGS="%optflags %optflags_shared" LDFLAGS="-pie -Wl,-z,relro"
%makeinstall_std -C selinux-dbus-%version LSPP_PRIV=y SBINDIR="%_sbindir" LIBDIR="%_libdir" LIBEXECDIR="%_libexecdir" LIBSEPOLA="%_libdir/libsepol.a" CFLAGS="%optflags %optflags_shared" LDFLAGS="-pie -Wl,-z,relro"
%makeinstall_std -C semodule-utils-%version LSPP_PRIV=y SBINDIR="%_sbindir" LIBDIR="%_libdir" LIBEXECDIR="%_libexecdir" LIBSEPOLA="%_libdir/libsepol.a" CFLAGS="%optflags %optflags_shared" LDFLAGS="-pie -Wl,-z,relro"
%makeinstall_std -C restorecond-%version LSPP_PRIV=y SBINDIR="%_sbindir" LIBDIR="%_libdir" LIBEXECDIR="%_libexecdir" LIBSEPOLA="%_libdir/libsepol.a" CFLAGS="%optflags %optflags_shared" LDFLAGS="-pie -Wl,-z,relro"
%makeinstall_std -C mcstrans-%version SBINDIR="%_sbindir" LIBDIR=%_libdir CFLAGS="%optflags $(pkg-config --cflags-only-I libpcre2)" LIBSEPOLA="%_libdir/libsepol.a" SYSTEMDDIR="%_systemddir"

%if "%python3_sitelibdir_noarch" != "%python3_sitelibdir"
mkdir -pv %buildroot%python3_sitelibdir
mv  %buildroot%python3_sitelibdir_noarch/* %buildroot%python3_sitelibdir/
rm -rf %buildroot%_prefix/lib/python3*
%endif

chmod -x %buildroot%python3_sitelibdir/seobject.py

install -d -m 0755 %buildroot%_localstatedir/selinux
install -D -m 0644 %SOURCE3 %buildroot%_sysconfdir/pam.d/system-config-selinux
install -D -m 0644 %SOURCE3 %buildroot%_sysconfdir/pam.d/selinux-polgengui
install -D -m 0644 %SOURCE6 %buildroot%_sysconfdir/security/console.apps/system-config-selinux
install -D -m 0644 %SOURCE8 %buildroot%_sysconfdir/security/console.apps/selinux-polgengui

# sysvinit
install -D -m 0755 %SOURCE1 %buildroot%_initddir/restorecond
install -D -m 0755 %SOURCE2 %buildroot%_initddir/sandbox
install -D -m 0755 %SOURCE9 %buildroot%_initddir/mcstrans

install -d -m 0755 %buildroot{%_datadir/mcstrans,%_sysconfdir/selinux/mls/setrans.d}
cp -r mcstrans-%version/share/* %buildroot%_datadir/mcstrans/

%find_lang --with-man --all-name %name

%triggerin -- selinux-policy
[ -f %_datadir/selinux/devel/include/build.conf ] && sepolgen-ifgen ||:

%post restorecond
%post_service restorecond

%preun restorecond
%preun_service restorecond

%post mcstransd
%post_service mcstrans

%preun mcstransd
%preun_service mcstrans

#
# stanv@ note:
# Fedora spec file has additional sub-packages: -python, -python3. 
# Put it contents here, to main policycoreutils package
#
%files -f %name.lang
%_sbindir/restorecon
%_sbindir/restorecon_xattr
%_sbindir/fixfiles
%_sbindir/setfiles
%_sbindir/unsetfiles
%_sbindir/load_policy
%_sbindir/genhomedircon
%_sbindir/setsebool
%_sbindir/semodule
%_sbindir/sestatus
%_bindir/secon
%_bindir/sestatus
%_libexecdir/selinux/hll/
%config(noreplace) %_sysconfdir/sestatus.conf

#
# Fedora python sub-package
#
%_sbindir/semanage
%_bindir/chcat
%_bindir/audit2allow
%_bindir/audit2why
%_bindir/semodule_package

#
# Policy Kit config, send_destination="org.selinux"
#
%config(noreplace) %_sysconfdir/dbus-1/system.d/org.selinux.conf
%dir /var/lib/selinux

#
# Fedora doesn't pack them.
# run_init isn't required for systemd
%_sbindir/run_init
%_sbindir/open_init_pty
%config(noreplace) %_sysconfdir/pam.d/run_init

%_datadir/bash-completion/completions/semanage
%_datadir/bash-completion/completions/setsebool

%_man5dir/selinux_config.*
%_man5dir/sestatus.conf*
%_man8dir/fixfiles.*
%_man8dir/load_policy.*
%_man8dir/restorecon.*
%_man8dir/restorecon_xattr.*
%_man8dir/semodule.*
%_man8dir/sestatus.*
%_man8dir/setsebool.*
%_man8dir/setfiles.*
%_man1dir/unsetfiles.*
%_man1dir/audit2allow.*
%_man1dir/audit2why.*
%_man8dir/chcat.*
%_man8dir/semanage.*
%_man8dir/semanage-*.*
%_man8dir/semodule_package.*
%_man1dir/secon.*
%_man8dir/genhomedircon.*
# Remove ?
%_man8dir/open_init_pty.*
%_man8dir/run_init.*


%files newrole
%config(noreplace) %_sysconfdir/pam.d/newrole
%attr(4511,root,root) %_bindir/newrole
%_man1dir/newrole.*

#
# stanv@:
# sandbox - useless for selinux-policy-altlinux.
# Leave it for ref-policy.
#
%files sandbox
%_bindir/sandbox
%_sbindir/seunshare
%_initddir/sandbox
%config(noreplace) %_sysconfdir/sysconfig/sandbox
%_man5dir/sandbox.*
%_man8dir/sandbox.*
%_man8dir/seunshare.*


%files sandbox-x
%_datadir/sandbox


%files restorecond
%_unitdir/restorecond.service
%_prefix/lib/systemd/user/restorecond_user.service
%_datadir/dbus-1/services/org.selinux.Restorecond.service
%_sbindir/restorecond
%_initddir/restorecond
%config(noreplace) %_sysconfdir/selinux/restorecond*
%_man8dir/restorecond.*

%files mcstransd
%_sbindir/mcstransd
%_initrddir/mcstrans
%_unitdir/mcstrans.service
%dir %_sysconfdir/selinux/mls
%dir %_sysconfdir/selinux/mls/setrans.d
%_man5dir/setrans.conf.*
%_man8dir/mcs.*
%_man8dir/mcstransd.*
%_datadir/mcstrans

%files devel
%_bindir/sepolgen
%_bindir/sepolicy
%_bindir/semodule_expand
%_bindir/semodule_link
%_bindir/semodule_unpackage

%_datadir/bash-completion/completions/sepolicy

%dir %_localstatedir/sepolgen
%_localstatedir/sepolgen/perm_map

%_man8dir/sepolgen.*
%_man8dir/sepolicy-booleans.*
%_man8dir/sepolicy-generate.*
%_man8dir/sepolicy-interface.*
%_man8dir/sepolicy-network.*
%_man8dir/sepolicy.*
%_man8dir/sepolicy-communicate.*
%_man8dir/sepolicy-manpage.*
%_man8dir/sepolicy-transition.*
%_man8dir/semodule_expand.*
%_man8dir/semodule_link.*
%_man8dir/semodule_unpackage.*


%files gui
%_bindir/system-config-selinux
%_bindir/selinux-polgengui
%_bindir/sepolgen-ifgen
%_bindir/sepolgen-ifgen-attr-helper

%_iconsdir/hicolor/*/apps/system-config-selinux.png
%_pixmapsdir/system-config-selinux.png
%_iconsdir/hicolor/*/apps/sepolicy.png
%_pixmapsdir/sepolicy.png

%dir %_datadir/system-config-selinux
%_datadir/system-config-selinux/*.py*
%_datadir/system-config-selinux/__pycache__
%_datadir/system-config-selinux/*png
%_datadir/system-config-selinux/*.ui

%_desktopdir/selinux-polgengui.desktop
%_desktopdir/sepolicy.desktop
%_desktopdir/system-config-selinux.desktop

%_xdgconfigdir/autostart/restorecond.desktop

%config(noreplace) %_sysconfdir/pam.d/system-config-selinux
%config(noreplace) %_sysconfdir/pam.d/selinux-polgengui
%config(noreplace) %_sysconfdir/security/console.apps/system-config-selinux
%config(noreplace) %_sysconfdir/security/console.apps/selinux-polgengui

%_datadir/polkit-1/actions/org.selinux.policy
%_datadir/polkit-1/actions/org.selinux.config.policy
%_datadir/dbus-1/system-services/org.selinux.service

%_man8dir/system-config-selinux.*
%_man8dir/selinux-polgengui.*
%_man8dir/sepolicy-gui.*

%files -n python3-module-policycoreutils
%python3_sitelibdir/sepolicy/
%python3_sitelibdir/sepolgen/
%python3_sitelibdir/sepolicy-*.dist-info
%python3_sitelibdir/seobject.py
%python3_sitelibdir/__pycache__/*
%exclude %python3_sitelibdir/sepolicy/gui.py
%exclude %python3_sitelibdir/sepolicy/__pycache__/gui*.py*
%exclude %python3_sitelibdir/sepolicy/sepolicy.glade

%files -n python3-module-policycoreutils-gui
%python3_sitelibdir/sepolicy/gui.py
%python3_sitelibdir/sepolicy/__pycache__/gui*.py*
%python3_sitelibdir/sepolicy/sepolicy.glade

%changelog
