%define popIF_ver_gt() %if "%(rpmvercmp '%1' '%2')" > "0"
%define popIF_ver_gteq() %if "%(rpmvercmp '%1' '%2')" >= "0"
%define popIF_ver_lt() %if "%(rpmvercmp '%2' '%1')" > "0"
%define popIF_ver_lteq() %if "%(rpmvercmp '%2' '%1')" >= "0"

%def_enable compat
%def_enable jpeg2000

%if_disabled compat
%def_enable cpp
%def_enable glib
%def_enable qt6
%def_enable qt5
%def_enable devel
%def_enable utils
%def_enable xpdfheaders
%def_enable gir
%def_enable cryptopro
%else
%def_disable cpp
%def_disable glib
%def_disable qt6
%def_disable qt5
%def_disable devel
%def_disable utils
%def_disable xpdfheaders
%def_disable gir
%endif

%define rname poppler
%define somajor 146
%define somajor_cpp 2
%define somajor_qt 3
%define somajor_qt5 1
%define somajor_qt6 3
%define somajor_glib 8
%define major 25
%define minor 02
%define bugfix 0

%if_disabled compat
%define pkgname %rname-current
%else
%define pkgname %rname%somajor
%endif
Name: %pkgname
Version: %major.%minor.%bugfix
Release: alt5

%if_disabled compat
%define poppler_devel lib%rname-devel
%define poppler_cpp_devel lib%rname-cpp-devel
%define poppler_glib_devel lib%rname-glib-devel
%define poppler_qt_devel lib%rname-qt-devel
%define poppler_qt5_devel lib%rname-qt5-devel
%define poppler_qt6_devel lib%rname-qt6-devel
%else
%define poppler_devel lib%rname%somajor-devel
%define poppler_cpp_devel lib%rname%somajor-cpp-devel
%define poppler_glib_devel lib%rname%somajor-glib-devel
%define poppler_qt_devel lib%rname%somajor-qt-devel
%define poppler_qt5_devel lib%rname%somajor-qt5-devel
%define poppler_qt6_devel lib%rname%somajor-qt6-devel
%endif
%define libpoppler libpoppler%somajor
%define libpoppler_qt5 lib%rname%somajor_qt5-qt5
%define libpoppler_qt6 lib%rname%somajor_qt6-qt6
%define libpoppler_glib lib%rname%somajor_glib-glib
%define libpoppler_cpp lib%rname%somajor_cpp-cpp
%define _cmake__builddir BUILD

Group: Publishing
Summary: PDF rendering library
License: GPL-2.0-only OR GPL-3.0-only
Url: http://poppler.freedesktop.org/
Packager: Sergey V Turchin <zerg at altlinux dot org>

Source: %rname-%version.tar
# ALT
Patch10: alt-e2k.patch
Patch11: alt-openjpeg-version.patch
Patch12: alt-add-cryptopro-sign-validation.patch

# Automatically added by buildreq on Fri Apr 01 2011 (-bi)
#BuildRequires: gcc-c++ glib-networking glibc-devel-static gtk-doc gvfs imake libXt-devel libcurl-devel libgtk+2-devel libgtk+2-gir-devel libjpeg-devel liblcms-devel libopenjpeg-devel libqt3-devel libqt4-devel libqt4-gui libqt4-xml libxml2-devel python-modules-compiler python-modules-encodings time xorg-cf-files

BuildRequires(pre): rpm-utils rpm-build-ubt
BuildRequires: cmake
%if_enabled qt6
BuildRequires: qt6-base-devel
%endif
%if_enabled qt5
BuildRequires: qt5-base-devel
%endif
%if_enabled glib
BuildRequires: glib2-devel
%endif
BuildRequires: gcc-c++ glibc-devel libcurl-devel zlib-devel libnss-devel libpcre-devel
BuildRequires: libjpeg-devel liblcms2-devel libtiff-devel libpng-devel
BuildRequires: libgtk+3-gir-devel libgtk+3-devel
%if_enabled jpeg2000
BuildRequires: libopenjpeg2.0-devel openjpeg-tools2.0
%endif
BuildRequires: libxml2-devel gtk-doc libcairo-gobject-devel
BuildRequires: libXt-devel poppler-data
BuildRequires: boost-devel libgpgme-devel
%if_enabled cryptopro
BuildRequires: libcspforpoppl-devel
BuildRequires: libgtest-devel
%endif

%description
Poppler is a fork of the xpdf PDF viewer developed by Derek Noonburg
of Glyph and Cog, LLC.  The purpose of forking xpdf is twofold.
First, we want to provide PDF rendering functionality as a shared
library, to centralize the maintenence effort.  Today a number of
applications incorporate the xpdf code base, and whenever a security
issue is discovered, all these applications exchange patches and put
out new releases.  In turn, all distributions must package and release
new version of these xpdf based viewers.  It's safe to say that
there's a lot of duplicated effort with the current situaion.  Even if
poppler in the short term introduces yet another xpdf derived code
base to the world, we hope that over time these applications will
adopt poppler.  After all, we only need one application to use poppler
to break even.

%package -n %libpoppler
Summary: PDF rendering library
Group: System/Libraries
Requires: poppler-data
%description -n %libpoppler
Poppler is a fork of the xpdf PDF viewer developed by Derek Noonburg
of Glyph and Cog, LLC.  The purpose of forking xpdf is twofold.
First, we want to provide PDF rendering functionality as a shared
library, to centralize the maintenence effort.  Today a number of
applications incorporate the xpdf code base, and whenever a security
issue is discovered, all these applications exchange patches and put
out new releases.  In turn, all distributions must package and release
new version of these xpdf based viewers.  It's safe to say that
there's a lot of duplicated effort with the current situaion.  Even if
poppler in the short term introduces yet another xpdf derived code
base to the world, we hope that over time these applications will
adopt poppler.  After all, we only need one application to use poppler
to break even.

%package -n %rname
Group: Publishing
Summary: PDF rendering library utils
Requires: %libpoppler
Provides: poppler-utils = %version-%release
Provides: xpdf-utils = 3.02-alt6
Obsoletes: xpdf-utils <= 3.02-alt5
Conflicts: xpdf-reader <= 3.02-alt5
Conflicts: pdftohtml
%description -n %rname
Poppler is a fork of the xpdf PDF viewer developed by Derek Noonburg
of Glyph and Cog, LLC.  The purpose of forking xpdf is twofold.
First, we want to provide PDF rendering functionality as a shared
library, to centralize the maintenence effort.  Today a number of
applications incorporate the xpdf code base, and whenever a security
issue is discovered, all these applications exchange patches and put
out new releases.  In turn, all distributions must package and release
new version of these xpdf based viewers.  It's safe to say that
there's a lot of duplicated effort with the current situaion.  Even if
poppler in the short term introduces yet another xpdf derived code
base to the world, we hope that over time these applications will
adopt poppler.  After all, we only need one application to use poppler
to break even.

%package -n %libpoppler_qt5
Summary: Qt5 frontend library for %rname
Group: System/Libraries
Requires: %libpoppler
%description -n %libpoppler_qt5
Qt5 frontend library for %rname

%package -n %libpoppler_qt6
Summary: Qt6 frontend library for %rname
Group: System/Libraries
Requires: %libpoppler
%description -n %libpoppler_qt6
Qt6 frontend library for %rname

%package -n %libpoppler_glib
Summary: Glib frontend library for %rname
Group: System/Libraries
Requires: %libpoppler
%description -n %libpoppler_glib
Glib frontend library for %rname

%package -n %libpoppler_cpp
Summary: Pure C++ wrapper for poppler
Group: System/Libraries
Requires: %libpoppler
%description -n %libpoppler_cpp
Pure C++ wrapper for poppler

%package -n %poppler_devel
Summary: Development files for %rname
Group: Development/C
Provides: %libpoppler-devel = %version-%release
Obsoletes: %libpoppler-devel < %version-%release
Requires: %libpoppler
%if_enabled compat
Conflicts: lib%rname-devel
%endif
%description -n %poppler_devel
Libraries, include files, etc you can use to develop poppler applications

%package -n %poppler_cpp_devel
Summary: Development files for C++ wrapper
Group: Development/C++
Requires: %libpoppler_cpp
%if_enabled xpdfheaders
Requires: %poppler_devel
%endif
%if_enabled compat
Conflicts: lib%rname-cpp-devel
%endif
%description -n %poppler_cpp_devel
Libraries, include files, etc you can use to develop
poppler applications with pure C++

%package -n %poppler_glib_devel
Summary: Development files for %rname-glib
Group: Development/GNOME and GTK+
Requires: %libpoppler_glib
%if_enabled xpdfheaders
Requires: %poppler_devel
%endif
%if_enabled compat
Conflicts: lib%rname-glib-devel
%endif
%description -n %poppler_glib_devel
Libraries, include files, etc you can use to develop
poppler applications with Glib/Gtk+

%package -n %poppler_qt6_devel
Summary: Development files for %rname-qt6
Group: Development/KDE and QT
Requires: %libpoppler_qt6
%if_enabled xpdfheaders
Requires: %poppler_devel
%endif
%if_enabled compat
Conflicts: lib%rname-qt6-devel
%endif
%description -n %poppler_qt6_devel
Libraries, include files, etc you can use to develop
poppler applications with Qt6

%package -n %poppler_qt5_devel
Summary: Development files for %rname-qt5
Group: Development/KDE and QT
Requires: %libpoppler_qt5
%if_enabled xpdfheaders
Requires: %poppler_devel
%endif
%if_enabled compat
Conflicts: lib%rname-qt5-devel
%endif
%description -n %poppler_qt5_devel
Libraries, include files, etc you can use to develop
poppler applications with Qt5

%package -n lib%rname-gir
Summary: GObject introspection data for the Poppler library
Group: System/Libraries
Requires: %libpoppler_glib
%description -n lib%rname-gir
GObject introspection data for the Poppler library

%package -n lib%rname-gir-devel
Summary: GObject introspection devel data for the Poppler library
Group: System/Libraries
BuildArch: noarch
Requires: lib%rname-gir
Requires: %poppler_glib_devel
%description -n lib%rname-gir-devel
GObject introspection devel data for the Poppler library

%prep
%setup -n %rname-%version
%patch10 -p1
%patch11 -p1
%if_enabled cryptopro
%patch12 -p1
%endif

%build
%cmake \
    -DSHARE_INSTALL_DIR=%_datadir \
    -DBUILD_SHARED_LIBS=ON \
    -DENABLE_GPGME=ON \
    -DDEFAULT_SIGNATURE_BACKEND=%{?_enable_cryptopro:"CRYPTOPRO"}%{!?_enable_cryptopro:""} \
    -DENABLE_LIBCURL=ON \
    -DENABLE_ZLIB=OFF \
    -DENABLE_CMS=lcms2 \
    -DENABLE_DCTDECODER=libjpeg \
%if_enabled jpeg2000
    -DENABLE_LIBOPENJPEG=openjpeg2 \
%else
    -DENABLE_LIBOPENJPEG=unmaintained \
%endif
    -DENABLE_XPDF_HEADERS=%{?_enable_xpdfheaders:ON}%{!?_enable_xpdfheaders:OFF} \
    -DENABLE_UNSTABLE_API_ABI_HEADERS=%{?_enable_xpdfheaders:ON}%{!?_enable_xpdfheaders:OFF} \
    -DENABLE_UTILS=%{?_enable_utils:ON}%{!?_enable_utils:OFF} \
    -DENABLE_CPP=%{?_enable_cpp:ON}%{!?_enable_cpp:OFF} \
    -DENABLE_GLIB=%{?_enable_glib:ON}%{!?_enable_glib:OFF} \
    -DENABLE_QT5=%{?_enable_qt5:ON}%{!?_enable_qt5:OFF} \
    -DENABLE_QT6=%{?_enable_qt6:ON}%{!?_enable_qt6:OFF} \
    #
#    -DBUILD_GTK_TESTS=OFF \
#    -DBUILD_QT5_TESTS=OFF \
#    -DBUILD_QT6_TESTS=OFF \
#    -DBUILD_CPP_TESTS=OFF \
%cmake_build

%install
make install DESTDIR=%buildroot -C BUILD
#cmakeinstall_std

%find_lang --with-qt --output=%rname.lang pdfsig

%if_enabled utils
%files -n %rname -f %rname.lang
%_bindir/pdf*
%_man1dir/pdf*
%endif

%files -n %libpoppler
%doc AUTHORS ChangeLog NEWS README*
%_libdir/libpoppler.so.%somajor
%_libdir/libpoppler.so.%somajor.*

%if_enabled gir
%files -n lib%rname-gir
%_typelibdir/Poppler-*.typelib
%if_enabled devel
%files -n lib%rname-gir-devel
%_girdir/Poppler-*.gir
%endif
%endif

%if_enabled glib
%files -n %libpoppler_glib
%_libdir/libpoppler-glib.so.%somajor_glib
%_libdir/libpoppler-glib.so.%somajor_glib.*
%if_enabled devel
%files -n %poppler_glib_devel
%_includedir/poppler/glib/
%_libdir/libpoppler-glib.so
#%_pkgconfigdir/poppler-cairo.pc
%_pkgconfigdir/poppler-glib.pc
%endif
%endif

%if_enabled qt5
%files -n %libpoppler_qt5
%_libdir/libpoppler-qt5.so.%somajor_qt5
%_libdir/libpoppler-qt5.so.%somajor_qt5.*
%if_enabled devel
%files -n %poppler_qt5_devel
%_includedir/poppler/qt5/
%_libdir/libpoppler-qt5.so
%_pkgconfigdir/poppler-qt5.pc
%endif
%endif

%if_enabled qt6
%files -n %libpoppler_qt6
%_libdir/libpoppler-qt6.so.%somajor_qt6
%_libdir/libpoppler-qt6.so.%somajor_qt6.*
%if_enabled devel
%files -n %poppler_qt6_devel
%_includedir/poppler/qt6/
%_libdir/libpoppler-qt6.so
%_pkgconfigdir/poppler-qt6.pc
%endif
%endif

%if_enabled cpp
%files -n %libpoppler_cpp
%_libdir/libpoppler-cpp.so.%somajor_cpp
%_libdir/libpoppler-cpp.so.%somajor_cpp.*
%if_enabled devel
%files -n %poppler_cpp_devel
%_includedir/poppler/cpp/
%_libdir/libpoppler-cpp.so
%_pkgconfigdir/poppler-cpp.pc
%endif
%endif

%if_enabled devel
%if_enabled xpdfheaders
%files -n %poppler_devel
%dir %_includedir/poppler
%_includedir/poppler/*.h
%_includedir/poppler/fofi
%_includedir/poppler/splash/
%_includedir/poppler/goo/
%_libdir/libpoppler.so
%_pkgconfigdir/poppler.pc
#%_pkgconfigdir/poppler-splash.pc

%endif
%endif

%changelog
