%define pulseaudio_version 17.0

Name:     pulseaudio-module-xrdp
Version:  0.7
Release:  alt3

Summary:  xrdp sink / source pulseaudio modules
License:  Apache-2.0
Group:    Other
Url:      https://github.com/neutrinolabs/pulseaudio-module-xrdp

Packager: Andrey Cherepanov <cas@altlinux.org>

Source:   %name-%version.tar
Source1:  pulseaudio-src.tar

BuildRequires: libpulseaudio-devel

BuildRequires(pre): meson
BuildRequires: gcc-c++
BuildRequires: intltool jackit-devel libalsa-devel libasyncns-devel
BuildRequires: libavahi-devel libbluez-devel
BuildRequires: libcap-devel libdbus-devel libgdbm-devel libudev-devel
BuildRequires: liblirc-devel libltdl7-devel libsoxr-devel
BuildRequires: libsndfile-devel libspeex-devel libspeexdsp-devel libwebrtc-devel
BuildRequires: libSM-devel libX11-devel libXtst-devel libxcbutil-devel
BuildRequires: libGConf-devel
BuildRequires: libfftw3-devel libsbc-devel liborc-devel orc xmltoman
BuildRequires: libcheck-devel libssl-devel libsystemd-devel

%description
xrdp implements Audio Output redirection using PulseAudio, which is a
sound system used on POSIX operating systems.

%prep
%setup
tar xf %SOURCE1

%build
# Check currect pulseaudio version
pa_ver="$(pkg-config --modversion libpulse)"
if [ "$pa_ver" != "%pulseaudio_version" ]; then
    echo "Package builds with different version of Pulseaudio in repository."
    exit 1
fi

%undefine _configure_gettext
# Configure Pulseaudio like pulseaudio.spec
pushd pulseaudio-src
echo "%pulseaudio_version" > .tarball-version
%meson \
    -Ddoxygen=false \
    -Ddatabase=gdbm \
    -Daccess_group=audio \
    -Dadrian-aec=true \
    -Dbluez5=enabled \
    -Dgsettings=enabled \
    -Djack=enabled
popd
# Build pulseaudio-module-xrdp
%autoreconf
%configure PULSE_DIR=`pwd`/pulseaudio-src CFLAGS="-I`pwd`/pulseaudio-src/%_host_alias"
%make_build

%install
%makeinstall_std
rm -f %buildroot%_libdir/pulseaudio/modules/*.la

%check
%make_build check

%files
%doc README.md
%_libdir/pulseaudio/modules/*.so
%_sysconfdir/xdg/autostart/pulseaudio-xrdp.desktop
%_libexecdir/pulseaudio-module-xrdp/load_pa_modules.sh

%changelog
