%global _unpackaged_files_terminate_build 1
%define _libexecdir %_prefix/libexec

Name: pve-xtermjs
Summary: HTML/JS Shell client
Version: 5.5.0.2
Release: alt1
License: AGPL-3.0+
Group: Networking/WWW
Url: https://git.proxmox.com/

Vcs: git://git.proxmox.com/git/pve-xtermjs.git
Source: %name-%version.tar

#Support loongarch64 fix
Patch3500: pve-xtermjs-5.3.0.3-alt-loongarch64_nix_vendor_fix.patch

ExclusiveArch: x86_64 aarch64 loongarch64
BuildRequires(pre): rpm-macros-rust
BuildRequires: rpm-build-rust pkgconfig(openssl) libuuid-devel
BuildRequires: /proc
BuildRequires: cargo-vendor-checksum

%description
This is an xterm.js client for PVE Host, Container and Qemu Serial Terminal

%prep
%setup
%patch3500 -p1

# Checksum update for patched files
cargo-vendor-checksum \
    --vendor %_builddir/%name-%version/termproxy/vendor -f \
	nix/src/sys/ioctl/linux.rs

%build
#export BUILD_MODE=release
#%%make_build
pushd termproxy
%rust_build
popd

#sed -i 's|Proxmox|PVE|' xterm.js/src/index.html.tpl.in
sed -e "s/@VERSION@/%version/" xterm.js/src/index.html.tpl.in > xterm.js/src/index.html.tpl
sed -e "s/@VERSION@/%version/" xterm.js/src/index.html.hbs.in > xterm.js/src/index.html.hbs
rm xterm.js/src/index.html.tpl.in xterm.js/src/index.html.hbs.in

%install
pushd termproxy
#%%rust_install proxmox-termproxy
install -dm755 %buildroot%_libexecdir/proxmox/
install -m755 target/release/proxmox-termproxy %buildroot%_libexecdir/proxmox/
install -dm755 %buildroot%_bindir
ln -s %_libexecdir/proxmox/proxmox-termproxy %buildroot%_bindir/termproxy
popd
mkdir -p %buildroot%_datadir/%name
cp xterm.js/src/* %buildroot%_datadir/%name/

%files
%doc xterm.js/debian/copyright
%_libexecdir/proxmox/proxmox-termproxy
%_bindir/termproxy
%_datadir/%name

%changelog
