%define _unpackaged_files_terminate_build 1
%define pypi_name BTrees
%define oname %pypi_name

%define dynamic_mods %(echo `cat %SOURCE2 2>/dev/null || echo unknown`)

%def_with check

Name: python3-module-%oname
Version: 6.1
Release: alt1.1

Summary: Scalable persistent object containers
License: ZPL-2.1
Group: Development/Python3
Url: https://pypi.org/project/BTrees/
Vcs: https://github.com/zopefoundation/BTrees.git
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
Source2: dynamic_mods.list
%pyproject_runtimedeps_metadata
# dynamic names
%add_python3_req_skip %dynamic_mods
# mapping from PyPI name
# https://www.altlinux.org/Management_of_Python_dependencies_sources#Mapping_project_names_to_distro_names
Provides: python3-module-%{pep503_name %pypi_name} = %EVR
%py3_provides %dynamic_mods
BuildRequires(pre): rpm-build-pyproject
BuildRequires: python3-module-persistent-devel
%pyproject_builddeps_build
%if_with check
%pyproject_builddeps_metadata_extra test
%endif

%description
This package contains a set of persistent object containers built around
a modified BTree data structure. The trees are optimized for use inside ZODB's
"optimistic concurrency" paradigm, and include explicit resolution of
conflicts detected by that mechanism.

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR

%description tests
This package contains tests for %oname.

%prep
%setup
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata

%build
%add_optflags -fno-strict-aliasing
%pyproject_build

# make sure we provide actual names
# these names are generated at runtime, see src/BTrees/__init__.py for details
%pyproject_run -- python - <<-'ENDRUN'
from pathlib import Path
import BTrees

Path("mods.actual.list").write_text(
    "\n".join(sorted([f'BTrees.{n}BTree' for n in BTrees._FAMILIES])) + "\n",
    encoding="utf-8",
)
ENDRUN

sort %SOURCE2 > mods.expected.list
diff -y mods.expected.list mods.actual.list || {
    echo 'Update expected list of mods: %SOURCE2' ;
    exit 1 ;
}

%install
%pyproject_install

# don't ship sources for C extensions
rm %buildroot%python3_sitelibdir/%pypi_name/*.{h,c}

%check
%pyproject_run -- zope-testrunner --test-path=src -vv

%files
%doc LICENSE.txt *.rst
%python3_sitelibdir/%oname
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/
%exclude %python3_sitelibdir/*/tests

%files tests
%python3_sitelibdir/*/tests

%changelog
