%define oname Eve-Elastic

# tests need network
%def_without check

Name: python3-module-%oname
Version: 7.4.3
Release: alt1.1

Summary: Elasticsearch data layer for eve rest framework
License: GPL-3.0
Group: Development/Python3
Url: https://pypi.org/project/Eve-Elastic
Vcs: https://github.com/superdesk/eve-elastic

Source: %name-%version.tar

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-eve
BuildRequires: python3-module-elasticsearch
BuildRequires: python3-module-arrow
BuildRequires: python3-module-ciso8601
BuildRequires: python3-module-pytz
%endif

%py3_provides eve_elastic

%description
Eve-Elastic is elasticsearch data layer for eve REST framework.

Features:

* fulltext search
* filtering via elasticsearch filter dsl
* facets support
* aggragations support
* elasticsearch mapping generator for schema

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest -v

%files
%doc README.*
%python3_sitelibdir/eve_elastic
%python3_sitelibdir/%{pyproject_distinfo %oname}/


%changelog
