%define oname RestrictedPython

%def_with check

Name: python3-module-%oname
Version: 8.0
Release: alt1.1
Summary: Provides a restricted execution environment for Python, e.g. for running untrusted code
License: ZPL-2.1
Group: Development/Python3
URL: https://pypi.org/project/RestrictedPython
VCS: https://github.com/zopefoundation/RestrictedPython

Source: %name-%version.tar
BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)

%if_with check
BuildRequires: python3(pytest)
BuildRequires: python3(pytest_mock)
BuildRequires: python3(tox)
BuildRequires: python3(tox_console_scripts)
%endif

%description
RestrictedPython provides a restricted execution environment for Python,
e.g. for running untrusted code.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install
%if "%python3_sitelibdir_noarch" != "%python3_sitelibdir"
install -d %buildroot%python3_sitelibdir
mv %buildroot%python3_sitelibdir_noarch/* \
        %buildroot%python3_sitelibdir/
%endif

%check
%tox_create_default_config
%tox_check_pyproject

%files
%doc *.txt
%python3_sitelibdir/%oname/
%python3_sitelibdir/%{pyproject_distinfo %oname}/

%changelog
