%define _unpackaged_files_terminate_build 1
%define oname ZopeUndo

%def_with check

Name: python3-module-%oname
Version: 6.0
Release: alt1.1

Summary: ZODB undo support for Zope2
License: ZPL-2.1
Group: Development/Python3
Url: https://pypi.org/project/ZopeUndo
Vcs: https://github.com/zopefoundation/ZopeUndo
BuildArch: noarch

Source: %name-%version.tar

# mapping from PyPI name
# https://www.altlinux.org/Management_of_Python_dependencies_sources#Mapping_project_names_to_distro_names
Provides: python3-module-%{pep503_name %oname} = %EVR

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
%if_with check
BuildRequires: python3-module-zope.testrunner
%endif

%description
This package is used to support the Prefix object that Zope 2 uses for
the undo log. It is a separate package only to aid configuration
management.

This package is included in Zope 2. It can be used in a ZEO server to
allow it to support Zope 2's undo log , without pulling in all of Zope
2.

%package tests
Summary: Tests for ZopeUndo
Group: Development/Python3
Requires: %name = %EVR

%description tests
This package is used to support the Prefix object that Zope 2 uses for
the undo log. It is a separate package only to aid configuration
management.

This package contains tests for ZopeUndo.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run -- zope-testrunner --test-path=src -vv

%files
%doc README.*
%python3_sitelibdir/%oname
%python3_sitelibdir/%{pyproject_distinfo %oname}/
%exclude %python3_sitelibdir/*/tests

%files tests
%python3_sitelibdir/*/tests


%changelog
