%define oname Babel
%def_without import_cldr

%def_with doc
%def_with check

Name: python3-module-babel
Version: 2.14.0
Release: alt1.1
Epoch: 1

Summary: a collection of tools for internationalizing Python applications
License: BSD
Group: Development/Python3

Url: http://babel.pocoo.org/

Source: Babel-%version.tar.gz
# LC_ALL=ru_RU.UTF-8 python3 -m pytest tests |& sed -En '/^FAILED tests/s/.*::([^[ ]*).*/\1/p' | sort -u | tr '\n' ' ' > Babel-failed_tests

BuildArch: noarch

BuildRequires(pre): rpm-build-intro >= 2.2.5
BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-macros-sphinx3

# Automatically added by buildreq on Fri Mar 24 2023
# optimized out: libgpg-error python-sphinx-objects.inv python3 python3-base python3-dev python3-module-Pygments python3-module-cffi python3-module-charset-normalizer python3-module-pkg_resources python3-module-pytz python3-module-setuptools python3-module-sphinx sh4
BuildRequires: python3-module-pyproject-installer python3-module-wheel python3-module-sphinx unzip
BuildRequires: python3-module-setuptools

%if_with import_cldr
BuildRequires: cldr
%endif

%if_with check
BuildRequires: python3-module-pytest python3-module-freezegun python3-module-pytz
%endif

%description
Babel is an integrated collection of utilities that assist in
internationalizing and localizing Python applications, with an emphasis
on web-based applications.
The functionality Babel provides for internationalization (I18n) and
localization (L10N) can be separated into two different aspects:
  * tools to build and work with gettext message catalogs, and
  * a Python interface to the CLDR (Common Locale Data Repository),
    providing access to various locale display names, localized number
    and date formatting, etc.

%prep
%if_with import_cldr
%setup -T -n %oname-%version/cldr -c -a1
%endif
%setup -D -n %oname-%version

%if_with doc
%prepare_sphinx3 .
%endif

%build
%if_with import_cldr
python3 scripts/import_cldr.py /usr/share/unicode/cldr/common
%endif
%pyproject_build

%install
%pyproject_install
%python3_prune

%if_with doc
%make -C docs html SPHINXBUILD=sphinx-build-3
%endif

%if_with check
%check
LC_ALL=ru_RU.UTF-8 python3 -m pytest tests # -k "not `sed -E 's/ (.)/ and not \1/g' #SOURCE100`"
%endif

%files
%doc AUTHORS* CHANGES* README*
%if_with doc
%doc docs/_build/html
%endif
%_bindir/pybabel
%python3_sitelibdir/*

%changelog
