%define _unpackaged_files_terminate_build 1
%define pypi_name botocore

%def_with check

Name: python3-module-%pypi_name
Version: 1.34.49
Release: alt1
Summary: The low-level, core functionality of boto 3
License: Apache-2.0
Group: Development/Python3
Url: https://pypi.org/project/botocore/
Vcs: https://github.com/boto/botocore
BuildArch: noarch
Source: %name-%version.tar
Source1: debundler.py.in
Source2: %pyproject_deps_config_name
Patch: %name-%version-alt.patch
%pyproject_runtimedeps_metadata
%pyproject_runtimedeps -- vendored
%filter_from_requires /python3(botocore\.vendored\..*)/d
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
# required for test_resource_leaks
BuildRequires: /proc
%pyproject_builddeps_metadata
%pyproject_builddeps -- vendored
%pyproject_builddeps_check
%endif

%description
A low-level interface to a growing number of Amazon Web Services. The
botocore package is the foundation for AWS-CLI.

%prep
%setup
%autopatch -p1

rm botocore/cacert.pem

VENDORED_PATH='botocore/vendored'
# gen vendored list for upstream (assume package/module name is the same as
# project name)
set -o pipefail
%__python3 - <<-EOF | sort -u > _vendor.txt
import pkgutil
for mod in pkgutil.iter_modules(["$VENDORED_PATH"]):
    if not mod.name.startswith("_"):
        print(mod.name)
EOF
%pyproject_deps_resync vendored pip_reqfile _vendor.txt

UNVENDORED_PATH="$VENDORED_PATH/__init__.py"
rm -r "$VENDORED_PATH"
mkdir "$VENDORED_PATH"
cp "%SOURCE1" "$UNVENDORED_PATH"
sed -i \
    -e 's/@VENDORED_ROOT@/"botocore.vendored"/' \
    -e 's/@VENDORED_FAKE_PACKAGES@/{"requests.packages"}/' \
    "$UNVENDORED_PATH"

%pyproject_deps_resync_build
%pyproject_deps_resync_metadata
%if_with check
%pyproject_deps_resync_check_pipreqfile requirements-dev.txt
%endif

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run -- python scripts/ci/run-tests --with-xdist

%files
%doc README.*
%python3_sitelibdir/%pypi_name
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
