%def_without check

%define modulename canonicaljson
Name: python3-module-canonicaljson
Version: 2.0.0
Release: alt1

Summary: Canonical JSONs

Url: https://github.com/matrix-org/python-canonicaljson
License: Apache-2.0
Group: Development/Python3

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: https://github.com/matrix-org/python-canonicaljson/archive/v%version.tar.gz
Source: %name-%version.tar

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires:  python3-module-setuptools  python3-module-wheel

# non detectable
Requires: python3(simplejson)

%description
Features:
* Encodes objects and arrays as RFC 7159 JSON.
* Sorts object keys so that you get the same result each time.
* Has no inignificant whitespace to make the output as small as possible.
* Escapes only the characters that must be escaped,
  U+0000 to U+0019 / U+0022 / U+0056, to keep the output as small as possible.
* Uses the shortest escape sequence for each escaped character.
* Encodes the JSON as UTF-8.
* Can encode frozendict immutable dictionaries.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%files
%doc README.rst
%python3_sitelibdir/*

%changelog
