%define oname chameleon
%def_with check

Name: python3-module-%oname.core
Version: 4.5.4
Release: alt1

Summary: Chameleon Template Compiler
License: BSD-4-Clause
Group: Development/Python3
URL: https://pypi.org/project/Chameleon
VCS: https://github.com/malthe/chameleon
BuildArch: noarch

Source: %name-%version.tar

BuildRequires: time

BuildRequires(pre): rpm-build-python3
BuildPreReq: python3-module-setuptools
BuildPreReq: python3-module-wheel
BuildPreReq: python3-module-sphinx
BuildPreReq: python3-module-sphinx_rtd_theme

%if_with check
BuildRequires: python3-module-zope.testrunner
BuildRequires: python3-module-pytest
%endif

%description
Attribute language template compiler.

%package tests
Summary: Tests for Chameleon Template Compiler
Group: Development/Python3
Requires: %name = %version-%release

%description tests
Attribute language template compiler.

This package contains tests for Chameleon Template Compiler.

%package pickles
Summary: Pickles for Chameleon Template Compiler
Group: Development/Python

%description pickles
Attribute language template compiler.

This package contains pickles for Chameleon Template Compiler.

%package docs
Summary: Documentation for Chameleon Template Compiler
Group: Development/Documentation

%description docs
Attribute language template compiler.

This package contains documentation for Chameleon Template Compiler.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

export PYTHONPATH=%buildroot%python3_sitelibdir
%make SPHINXBUILD="sphinx-build-3" pickle
%make SPHINXBUILD="sphinx-build-3" html
cp -fR _build/pickle %buildroot%python3_sitelibdir/%oname/

%check
%pyproject_run_pytest

%files
%doc *.txt *.rst
%python3_sitelibdir/*
%exclude %python3_sitelibdir/%oname/tests
%exclude %python3_sitelibdir/%oname/pickle

%files tests
%python3_sitelibdir/%oname/tests

%files pickles
%python3_sitelibdir/%oname/pickle

%files docs
%doc _build/html/*

%changelog
