%define _unpackaged_files_terminate_build 1

%define oname crochet

Name: python3-module-%oname
Version: 1.9.0
Release: alt4

Summary: Use Twisted anywhere!
License: MIT
Group: Development/Python3
Url: https://pypi.python.org/pypi/crochet

BuildArch: noarch

# https://github.com/itamarst/crochet.git
Source: %name-%version.tar
Patch1: %oname-%version-alt-docs.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-twisted-core-test python3-module-wrapt
BuildRequires: python3-module-service-identity
BuildRequires: python3-module-sphinx

%py3_requires twisted.internet

%description
Crochet is an MIT-licensed library that makes it easier to use Twisted
from regular blocking code. Some use cases include:

* Easily use Twisted from a blocking framework like Django or Flask.
* Write a library that provides a blocking API, but uses Twisted for its
  implementation.
* Port blocking code to Twisted more easily, by keeping a backwards
  compatibility layer.
* Allow normal Twisted programs that use threads to interact with
  Twisted more cleanly from their threaded parts. For example this can
  be useful when using Twisted as a WSGI container.

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR
Requires: python3-module-twisted-core-test

%description tests
Crochet is an MIT-licensed library that makes it easier to use Twisted
from regular blocking code. Some use cases include:

* Easily use Twisted from a blocking framework like Django or Flask.
* Write a library that provides a blocking API, but uses Twisted for its
  implementation.
* Port blocking code to Twisted more easily, by keeping a backwards
  compatibility layer.
* Allow normal Twisted programs that use threads to interact with
  Twisted more cleanly from their threaded parts. For example this can
  be useful when using Twisted as a WSGI container.

This package contains tests for %oname.

%package pickles
Summary: Pickles for %oname
Group: Development/Python

%description pickles
Crochet is an MIT-licensed library that makes it easier to use Twisted
from regular blocking code. Some use cases include:

* Easily use Twisted from a blocking framework like Django or Flask.
* Write a library that provides a blocking API, but uses Twisted for its
  implementation.
* Port blocking code to Twisted more easily, by keeping a backwards
  compatibility layer.
* Allow normal Twisted programs that use threads to interact with
  Twisted more cleanly from their threaded parts. For example this can
  be useful when using Twisted as a WSGI container.

This package contains pickles for %oname.

%prep
%setup
%patch1 -p1

sed -i 's|sphinx-build|&-3|' docs/Makefile

# hotfix for python3.12
sed -i 's/SafeConfigParser/ConfigParser/' versioneer.py
sed -i 's/readfp/read_file/' versioneer.py
# fix version info
sed -i \
	-e "s/git_refnames\s*=\s*\"[^\"]*\"/git_refnames = \" \(tag: %version\)\"/" \
	%oname/_version.py

%build
%python3_build_debug

%install
%python3_install

%make -C docs pickle
%make -C docs html
cp -fR docs/_build/pickle %buildroot%python3_sitelibdir/%oname/

%check
%__python3 -m unittest discover -v ||:

%files
%doc *.rst examples docs/_build/html
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version-py*.egg-info
%exclude %python3_sitelibdir/*/pickle
%exclude %python3_sitelibdir/*/tests

%files tests
%python3_sitelibdir/*/tests

%files pickles
%python3_sitelibdir/*/pickle

%changelog
